/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.rewards;

import betterquesting.api.placeholders.rewards.RewardPlaceholder;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.questing.rewards.RewardRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public class RewardStorage
extends SimpleDatabase<IReward>
implements IDatabaseNBT<IReward, NBTTagList, NBTTagList> {
    @Override
    public NBTTagList writeToNBT(NBTTagList json) {
        for (DBEntry rew : this.getEntries()) {
            ResourceLocation rewardID = ((IReward)rew.getValue()).getFactoryID();
            NBTTagCompound rJson = ((IReward)rew.getValue()).writeToNBT(new NBTTagCompound());
            rJson.func_74778_a("rewardID", rewardID.toString());
            rJson.func_74768_a("index", rew.getID());
            json.func_74742_a((NBTBase)rJson);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json) {
        this.reset();
        ArrayList<IReward> unassigned = new ArrayList<IReward>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jr2;
            ResourceLocation loc2;
            IReward r2;
            NBTBase entry = json.func_179238_g(i);
            if (entry.func_74732_a() != 10) continue;
            NBTTagCompound jsonReward = (NBTTagCompound)entry;
            ResourceLocation loc = new ResourceLocation(jsonReward.func_74779_i("rewardID"));
            int index = jsonReward.func_150297_b("index", 99) ? jsonReward.func_74762_e("index") : -1;
            IReward reward = RewardRegistry.INSTANCE.createReward(loc);
            if (reward instanceof RewardPlaceholder && (r2 = RewardRegistry.INSTANCE.createReward(loc2 = new ResourceLocation((jr2 = jsonReward.func_74775_l("orig_data")).func_74779_i("rewardID")))) != null) {
                jsonReward = jr2;
                reward = r2;
            }
            if (reward != null) {
                reward.readFromNBT(jsonReward);
                if (index >= 0) {
                    this.add(index, reward);
                    continue;
                }
                unassigned.add(reward);
                continue;
            }
            RewardPlaceholder rph = new RewardPlaceholder();
            rph.setRewardConfigData(jsonReward);
            if (index >= 0) {
                this.add(index, rph);
                continue;
            }
            unassigned.add(rph);
        }
        for (IReward r : unassigned) {
            this.add(this.nextID(), r);
        }
    }

    @Override
    public NBTTagList writeProgressToNBT(NBTTagList nbt, List<UUID> users) {
        return nbt;
    }

    @Override
    public void readProgressFromNBT(NBTTagList nbt, boolean merge) {
    }
}

