/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.party;

import betterquesting.api.enums.EnumPartyStatus;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.party.IParty;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.party.PartyManager;
import betterquesting.storage.PropertyContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PartyInstance
implements IParty {
    private final HashMap<UUID, EnumPartyStatus> members = new HashMap();
    private final PropertyContainer pInfo = new PropertyContainer();
    private final List<UUID> memCache = new ArrayList<UUID>();

    public PartyInstance() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Party");
        this.setupValue(NativeProps.PARTY_LIVES);
        this.setupValue(NativeProps.PARTY_LOOT);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.pInfo.setProperty(prop, this.pInfo.getProperty(prop, def));
    }

    private void refreshCache() {
        this.memCache.clear();
        for (Map.Entry<UUID, EnumPartyStatus> entry : this.members.entrySet()) {
            if (entry.getValue() == EnumPartyStatus.INVITE) continue;
            this.memCache.add(entry.getKey());
        }
    }

    @Override
    public String getName() {
        return this.pInfo.getProperty(NativeProps.NAME, "New Party");
    }

    @Override
    public IPropertyContainer getProperties() {
        return this.pInfo;
    }

    @Override
    public void inviteUser(UUID uuid) {
        if (uuid == null || this.members.containsKey(uuid)) {
            return;
        }
        if (this.members.size() == 0) {
            this.members.put(uuid, EnumPartyStatus.OWNER);
        } else {
            this.members.put(uuid, EnumPartyStatus.INVITE);
        }
        this.refreshCache();
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public void kickUser(UUID uuid) {
        if (!this.members.containsKey(uuid)) {
            return;
        }
        EnumPartyStatus old = this.members.get(uuid);
        this.members.remove(uuid);
        if (this.members.size() <= 0) {
            PartyManager.INSTANCE.removeValue(this);
            PacketSender.INSTANCE.sendToAll(PartyManager.INSTANCE.getSyncPacket());
        } else if (old == EnumPartyStatus.OWNER) {
            this.hostMigrate();
        }
        this.refreshCache();
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public void setStatus(UUID uuid, EnumPartyStatus priv) {
        if (!this.members.containsKey(uuid)) {
            return;
        }
        EnumPartyStatus old = this.members.get(uuid);
        if (old == priv) {
            return;
        }
        this.members.put(uuid, priv);
        if (priv == EnumPartyStatus.OWNER) {
            for (UUID mem : this.getMembers()) {
                if (mem == uuid || this.members.get(mem) != EnumPartyStatus.OWNER) continue;
                this.members.put(mem, EnumPartyStatus.ADMIN);
                break;
            }
        } else if (old == EnumPartyStatus.OWNER) {
            UUID migrate = null;
            for (UUID mem : this.getMembers()) {
                if (mem == uuid) continue;
                if (this.members.get(mem) == EnumPartyStatus.ADMIN) {
                    migrate = mem;
                    break;
                }
                if (migrate != null) continue;
                migrate = mem;
            }
            if (migrate == null) {
                this.members.put(uuid, old);
                return;
            }
            this.members.put(migrate, EnumPartyStatus.OWNER);
        }
        this.refreshCache();
        PacketSender.INSTANCE.sendToAll(this.getSyncPacket());
    }

    @Override
    public EnumPartyStatus getStatus(UUID uuid) {
        return this.members.get(uuid);
    }

    @Override
    public List<UUID> getMembers() {
        return this.memCache;
    }

    private void hostMigrate() {
        for (UUID uuid : this.memCache) {
            if (this.members.get(uuid) != EnumPartyStatus.OWNER) continue;
            return;
        }
        UUID migrate = null;
        for (UUID mem : this.getMembers()) {
            if (this.members.get(mem) == EnumPartyStatus.ADMIN) {
                migrate = mem;
                break;
            }
            if (migrate != null) continue;
            migrate = mem;
        }
        if (migrate != null) {
            this.members.put(migrate, EnumPartyStatus.OWNER);
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("data", (NBTBase)this.writeToNBT(new NBTTagCompound()));
        tags.func_74768_a("partyID", PartyManager.INSTANCE.getID(this));
        return new QuestingPacket(PacketTypeNative.PARTY_SYNC.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        this.readFromNBT(payload.func_74775_l("data"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        NBTTagList memJson = new NBTTagList();
        for (Map.Entry<UUID, EnumPartyStatus> mem : this.members.entrySet()) {
            NBTTagCompound jm = new NBTTagCompound();
            jm.func_74778_a("uuid", mem.getKey().toString());
            jm.func_74778_a("status", mem.getValue().toString());
            memJson.func_74742_a((NBTBase)jm);
        }
        json.func_74782_a("members", (NBTBase)memJson);
        json.func_74782_a("properties", (NBTBase)this.pInfo.writeToNBT(new NBTTagCompound()));
        return json;
    }

    @Override
    public void readFromNBT(NBTTagCompound jObj) {
        if (jObj.func_150297_b("properties", 10)) {
            this.pInfo.readFromNBT(jObj.func_74775_l("properties"));
        } else {
            this.pInfo.readFromNBT(new NBTTagCompound());
            this.pInfo.setProperty(NativeProps.NAME, jObj.func_74779_i("name"));
            this.pInfo.setProperty(NativeProps.PARTY_LIVES, jObj.func_74767_n("lifeShare"));
            this.pInfo.setProperty(NativeProps.PARTY_LOOT, jObj.func_74767_n("lootShare"));
            this.pInfo.setProperty(NativeProps.LIVES, jObj.func_74762_e("lives"));
        }
        this.members.clear();
        NBTTagList memList = jObj.func_150295_c("members", 10);
        for (int i = 0; i < memList.func_74745_c(); ++i) {
            EnumPartyStatus priv;
            UUID uuid;
            NBTTagCompound jMem = memList.func_150305_b(i);
            try {
                uuid = UUID.fromString(jMem.func_74779_i("uuid"));
            }
            catch (Exception e) {
                uuid = null;
            }
            try {
                priv = EnumPartyStatus.valueOf(jMem.func_150297_b("status", 8) ? jMem.func_74779_i("status") : EnumPartyStatus.INVITE.toString());
            }
            catch (Exception e) {
                priv = EnumPartyStatus.INVITE;
            }
            if (uuid == null) continue;
            this.members.put(uuid, priv);
        }
        this.refreshCache();
        this.setupProps();
    }
}

