/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.api2.utils.QuestLineSorter;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public final class QuestLineDatabase
extends SimpleDatabase<IQuestLine>
implements IQuestLineDatabase {
    public static final QuestLineDatabase INSTANCE = new QuestLineDatabase();
    private final List<Integer> lineOrder = new ArrayList<Integer>();
    private final QuestLineSorter SORTER = new QuestLineSorter(this);

    @Override
    public int getOrderIndex(int lineID) {
        if (this.getValue(lineID) == null) {
            return -1;
        }
        if (!this.lineOrder.contains(lineID)) {
            this.lineOrder.add(lineID);
        }
        return this.lineOrder.indexOf(lineID);
    }

    @Override
    public void setOrderIndex(int lineID, int index) {
        this.lineOrder.remove((Object)lineID);
        this.lineOrder.add(index, lineID);
    }

    @Override
    public DBEntry<IQuestLine>[] getSortedEntries() {
        DBEntry<T>[] array = this.getEntries();
        Arrays.sort(array, this.SORTER);
        return array;
    }

    @Override
    public IQuestLine createNew(int id) {
        QuestLine ql = new QuestLine();
        ql.setParentDatabase(this);
        this.add(id, ql);
        return ql;
    }

    @Override
    public void removeQuest(int questID) {
        for (DBEntry ql : this.getEntries()) {
            ((IQuestLine)ql.getValue()).removeID(questID);
        }
    }

    @Override
    public QuestingPacket getSyncPacket() {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("data", (NBTBase)this.writeToNBT(new NBTTagList(), (List<UUID>)null));
        return new QuestingPacket(PacketTypeNative.LINE_DATABASE.GetLocation(), tags);
    }

    @Override
    public void readPacket(NBTTagCompound payload) {
        this.readFromNBT(payload.func_150295_c("data", 10), false);
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, List<UUID> users) {
        for (DBEntry entry : this.getEntries()) {
            NBTTagCompound jObj = ((IQuestLine)entry.getValue()).writeToNBT(new NBTTagCompound(), users);
            jObj.func_74768_a("lineID", entry.getID());
            jObj.func_74768_a("order", this.getOrderIndex(entry.getID()));
            json.func_74742_a((NBTBase)jObj);
        }
        return json;
    }

    @Override
    public void readFromNBT(NBTTagList json, boolean merge) {
        this.reset();
        ArrayList<QuestLine> unassigned = new ArrayList<QuestLine>();
        HashMap<Integer, Integer> orderMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTBase iterator = json.func_179238_g(i);
            if (iterator.func_74732_a() != 10) continue;
            NBTTagCompound jql = (NBTTagCompound)iterator;
            int id = jql.func_150297_b("lineID", 99) ? jql.func_74762_e("lineID") : -1;
            int order = jql.func_150297_b("order", 99) ? jql.func_74762_e("order") : -1;
            QuestLine line = new QuestLine();
            line.readFromNBT(jql, merge);
            if (id >= 0) {
                this.add(id, line);
            } else {
                unassigned.add(line);
            }
            if (order < 0) continue;
            orderMap.put(order, id);
        }
        for (IQuestLine iQuestLine : unassigned) {
            this.add(this.nextID(), iQuestLine);
        }
        ArrayList orderKeys = new ArrayList(orderMap.keySet());
        Collections.sort(orderKeys);
        this.lineOrder.clear();
        Iterator iterator = orderKeys.iterator();
        while (iterator.hasNext()) {
            int o = (Integer)iterator.next();
            this.lineOrder.add((Integer)orderMap.get(o));
        }
    }
}

