/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network;

import betterquesting.api.network.IPacketHandler;
import betterquesting.api.network.IPacketRegistry;
import betterquesting.network.handlers.PktHandlerClaim;
import betterquesting.network.handlers.PktHandlerDetect;
import betterquesting.network.handlers.PktHandlerImport;
import betterquesting.network.handlers.PktHandlerLineDB;
import betterquesting.network.handlers.PktHandlerLineEdit;
import betterquesting.network.handlers.PktHandlerLineSync;
import betterquesting.network.handlers.PktHandlerLives;
import betterquesting.network.handlers.PktHandlerNameCache;
import betterquesting.network.handlers.PktHandlerNotification;
import betterquesting.network.handlers.PktHandlerPartyAction;
import betterquesting.network.handlers.PktHandlerPartyDB;
import betterquesting.network.handlers.PktHandlerPartySync;
import betterquesting.network.handlers.PktHandlerQuestDB;
import betterquesting.network.handlers.PktHandlerQuestEdit;
import betterquesting.network.handlers.PktHandlerQuestSync;
import betterquesting.network.handlers.PktHandlerSettings;
import betterquesting.network.handlers.PktHandlerTileEdit;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;

public class PacketTypeRegistry
implements IPacketRegistry {
    public static final PacketTypeRegistry INSTANCE = new PacketTypeRegistry();
    private final HashMap<ResourceLocation, IPacketHandler> pktHandlers = new HashMap();

    private PacketTypeRegistry() {
    }

    public void init() {
        this.registerHandler(new PktHandlerQuestDB());
        this.registerHandler(new PktHandlerQuestSync());
        this.registerHandler(new PktHandlerQuestEdit());
        this.registerHandler(new PktHandlerLineDB());
        this.registerHandler(new PktHandlerLineEdit());
        this.registerHandler(new PktHandlerLineSync());
        this.registerHandler(new PktHandlerPartyDB());
        this.registerHandler(new PktHandlerPartyAction());
        this.registerHandler(new PktHandlerPartySync());
        this.registerHandler(new PktHandlerDetect());
        this.registerHandler(new PktHandlerClaim());
        this.registerHandler(new PktHandlerLives());
        this.registerHandler(new PktHandlerNotification());
        this.registerHandler(new PktHandlerTileEdit());
        this.registerHandler(new PktHandlerNameCache());
        this.registerHandler(new PktHandlerImport());
        this.registerHandler(new PktHandlerSettings());
    }

    @Override
    public void registerHandler(IPacketHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Tried to register null packet handler");
        }
        if (handler.getRegistryName() == null) {
            throw new IllegalArgumentException("Tried to register a packet handler with a null name: " + handler.getClass());
        }
        if (this.pktHandlers.containsKey(handler.getRegistryName()) || this.pktHandlers.containsValue(handler)) {
            throw new IllegalArgumentException("Cannot register dupliate packet handler: " + handler.getRegistryName());
        }
        this.pktHandlers.put(handler.getRegistryName(), handler);
    }

    @Override
    public IPacketHandler getPacketHandler(ResourceLocation name) {
        return this.pktHandlers.get(name);
    }
}

