/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.core;

import betterquesting.api.placeholders.ItemPlaceholder;
import betterquesting.core.BetterQuesting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegEventHandler {
    public static final List<Item> ALL_ITEMS = new ArrayList<Item>();
    public static final List<Block> ALL_BLOCKS = new ArrayList<Block>();
    public static final List<IRecipe> ALL_RECIPES = new ArrayList<IRecipe>();
    private static boolean setupRecipes = false;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModelEvent(ModelRegistryEvent event) {
        BetterQuesting.proxy.registerRenderers();
    }

    @SubscribeEvent
    public static void registerBlockEvent(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ALL_BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void registerItemEvent(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ALL_ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void registerRecipeEvent(RegistryEvent.Register<IRecipe> event) {
        if (!setupRecipes) {
            RegEventHandler.initRecipes();
        }
        IRecipe[] tmp = ALL_RECIPES.toArray(new IRecipe[0]);
        event.getRegistry().registerAll((IForgeRegistryEntry[])tmp);
    }

    public static void registerBlock(Block b, String name) {
        ResourceLocation res = new ResourceLocation("betterquesting:" + name);
        ALL_BLOCKS.add((Block)b.setRegistryName(res));
        ALL_ITEMS.add((Item)new ItemBlock(b).setRegistryName(res));
    }

    public static void registerItem(Item i, String name) {
        ResourceLocation res = new ResourceLocation("betterquesting:" + name);
        ALL_ITEMS.add((Item)i.setRegistryName(res));
    }

    public static void addShapelessRecipe(String name, String group, ItemStack stack, Object ... ing) {
        ResourceLocation rName = new ResourceLocation("betterquesting", name);
        ResourceLocation rGroup = new ResourceLocation("betterquesting", group);
        ALL_RECIPES.add((IRecipe)new ShapelessOreRecipe(rGroup, stack, ing).setRegistryName(rName));
    }

    public static void initRecipes() {
        RegEventHandler.addShapelessRecipe("submit_station", "questing", new ItemStack(BetterQuesting.submitStation), new ItemStack(Items.field_151122_aG), new ItemStack(Blocks.field_150359_w), new ItemStack((Block)Blocks.field_150486_ae));
        RegEventHandler.addShapelessRecipe("life_full_0", "questing", new ItemStack(BetterQuesting.extraLife, 1, 0), new ItemStack(BetterQuesting.extraLife, 1, 2), new ItemStack(BetterQuesting.extraLife, 1, 2), new ItemStack(BetterQuesting.extraLife, 1, 2), new ItemStack(BetterQuesting.extraLife, 1, 2));
        RegEventHandler.addShapelessRecipe("life_full_1", "questing", new ItemStack(BetterQuesting.extraLife, 1, 0), new ItemStack(BetterQuesting.extraLife, 1, 2), new ItemStack(BetterQuesting.extraLife, 1, 2), new ItemStack(BetterQuesting.extraLife, 1, 1));
        RegEventHandler.addShapelessRecipe("life_full_2", "questing", new ItemStack(BetterQuesting.extraLife, 1, 0), new ItemStack(BetterQuesting.extraLife, 1, 1), new ItemStack(BetterQuesting.extraLife, 1, 1));
        RegEventHandler.addShapelessRecipe("life_half_0", "questing", new ItemStack(BetterQuesting.extraLife, 2, 1), new ItemStack(BetterQuesting.extraLife, 1, 0));
        RegEventHandler.addShapelessRecipe("life_half_1", "questing", new ItemStack(BetterQuesting.extraLife, 1, 1), new ItemStack(BetterQuesting.extraLife, 1, 2), new ItemStack(BetterQuesting.extraLife, 1, 2));
        RegEventHandler.addShapelessRecipe("life_quarter_0", "questing", new ItemStack(BetterQuesting.extraLife, 2, 2), new ItemStack(BetterQuesting.extraLife, 1, 1));
        setupRecipes = true;
    }

    static {
        RegEventHandler.registerItem(ItemPlaceholder.placeholder, "placeholder");
        RegEventHandler.registerItem(BetterQuesting.extraLife, "extra_life");
        RegEventHandler.registerItem(BetterQuesting.guideBook, "guide_book");
        RegEventHandler.registerBlock(BetterQuesting.submitStation, "submit_station");
    }
}

