/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.commands.QuestCommandBase;
import betterquesting.network.PacketSender;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class QuestCommandLives
extends QuestCommandBase {
    @Override
    public String getCommand() {
        return "lives";
    }

    @Override
    public String getUsageSuffix() {
        return "[add|set|max|default] <value> [username|uuid]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 4 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 4 && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("set"))) {
            return CommandBase.func_175762_a((String[])args, NameCache.INSTANCE.getAllNames());
        }
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "set", "max", "default"});
        }
        return list;
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        String pName;
        String action = args[1];
        int value = 0;
        UUID playerID = null;
        try {
            value = Integer.parseInt(args[2]);
        }
        catch (Exception e) {
            throw this.getException(command);
        }
        if (args.length >= 4 && (playerID = this.findPlayerID(server, sender, args[3])) == null) {
            throw this.getException(command);
        }
        String string = pName = playerID == null ? "NULL" : NameCache.INSTANCE.getName(playerID);
        if (action.equalsIgnoreCase("set")) {
            value = Math.max(1, value);
            if (playerID != null) {
                LifeDatabase.INSTANCE.setLives(playerID, value);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.set_player", new Object[]{pName, value}));
            } else if (args.length == 3) {
                for (EntityPlayer p : server.func_184103_al().func_181057_v()) {
                    LifeDatabase.INSTANCE.setLives(QuestingAPI.getQuestingUUID(p), value);
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.set_all", new Object[]{value}));
            }
            PacketSender.INSTANCE.sendToAll(LifeDatabase.INSTANCE.getSyncPacket());
            return;
        }
        if (action.equalsIgnoreCase("add")) {
            if (playerID != null) {
                int lives = LifeDatabase.INSTANCE.getLives(playerID);
                LifeDatabase.INSTANCE.setLives(playerID, lives + value);
                lives = LifeDatabase.INSTANCE.getLives(playerID);
                if (value >= 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.add_player", new Object[]{value, pName, lives}));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.remove_player", new Object[]{Math.abs(value), pName, lives}));
                }
            } else {
                for (EntityPlayer p : server.func_184103_al().func_181057_v()) {
                    int lives = LifeDatabase.INSTANCE.getLives(QuestingAPI.getQuestingUUID(p));
                    LifeDatabase.INSTANCE.setLives(QuestingAPI.getQuestingUUID(p), lives + value);
                }
                if (value >= 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.add_all", new Object[]{value}));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.remove_all", new Object[]{Math.abs(value)}));
                }
            }
            PacketSender.INSTANCE.sendToAll(LifeDatabase.INSTANCE.getSyncPacket());
            return;
        }
        if (action.equalsIgnoreCase("max")) {
            value = Math.max(1, value);
            QuestSettings.INSTANCE.setProperty(NativeProps.LIVES_MAX, value);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.max", new Object[]{value}));
            PacketSender.INSTANCE.sendToAll(LifeDatabase.INSTANCE.getSyncPacket());
            return;
        }
        if (action.equalsIgnoreCase("default")) {
            value = Math.max(1, value);
            QuestSettings.INSTANCE.setProperty(NativeProps.LIVES_DEF, value);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.lives.default" + value, new Object[0]));
            PacketSender.INSTANCE.sendToAll(LifeDatabase.INSTANCE.getSyncPacket());
            return;
        }
        throw this.getException(command);
    }

    @Override
    public boolean isArgUsername(String[] args, int index) {
        return index == 3;
    }
}

