/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.storage.DBEntry;
import betterquesting.commands.QuestCommandBase;
import betterquesting.network.PacketSender;
import betterquesting.questing.QuestDatabase;
import betterquesting.storage.NameCache;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class QuestCommandComplete
extends QuestCommandBase {
    @Override
    public String getUsageSuffix() {
        return "<quest_id> [username|uuid]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 2 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 2) {
            for (DBEntry i : QuestDatabase.INSTANCE.getEntries()) {
                list.add("" + i.getID());
            }
        } else if (args.length == 3) {
            return CommandBase.func_175762_a((String[])args, NameCache.INSTANCE.getAllNames());
        }
        return list;
    }

    @Override
    public String getCommand() {
        return "complete";
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) throws CommandException {
        UUID uuid;
        if (args.length >= 3) {
            uuid = this.findPlayerID(server, sender, args[2]);
            if (uuid == null) {
                throw this.getException(command);
            }
        } else {
            uuid = this.findPlayerID(server, sender, sender.func_70005_c_());
        }
        String pName = uuid == null ? "NULL" : NameCache.INSTANCE.getName(uuid);
        try {
            int id = Integer.parseInt(args[1].trim());
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(id);
            quest.setComplete(uuid, 0L);
            int done = 0;
            if (!quest.getProperty(NativeProps.LOGIC_TASK).getResult(done, quest.getTasks().size())) {
                for (DBEntry task : quest.getTasks().getEntries()) {
                    ((ITask)task.getValue()).setComplete(uuid);
                    if (quest.getProperty(NativeProps.LOGIC_TASK).getResult(++done, quest.getTasks().size())) break;
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("betterquesting.cmd.complete", new Object[]{new TextComponentTranslation(quest.getProperty(NativeProps.NAME), new Object[0]), pName}));
        }
        catch (Exception e) {
            throw this.getException(command);
        }
        PacketSender.INSTANCE.sendToAll(QuestDatabase.INSTANCE.getSyncPacket());
    }

    @Override
    public boolean isArgUsername(String[] args, int index) {
        return index == 2;
    }
}

