/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.gui.controls.GuiButtonQuestInstance;
import betterquesting.api.client.gui.misc.IGuiQuestLine;
import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.client.toolbox.ToolboxGuiMain;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ToolboxToolScale
implements IToolboxTool {
    private IGuiQuestLine gui;
    private int grabID = -1;
    private GuiButtonQuestInstance grabbed;

    @Override
    public void initTool(IGuiQuestLine gui) {
        this.gui = gui;
        this.grabbed = null;
        this.grabID = -1;
    }

    @Override
    public void disableTool() {
        IQuestLineEntry qle;
        if (this.grabbed != null && (qle = (IQuestLineEntry)this.gui.getQuestLine().getQuestLine().getValue(this.grabID)) != null) {
            this.grabbed.field_146120_f = qle.getSize();
            this.grabbed.field_146121_g = qle.getSize();
        }
        this.grabbed = null;
        this.grabID = -1;
    }

    @Override
    public void drawTool(int mx, int my, float partialTick) {
        if (this.grabbed != null) {
            int snap = ToolboxGuiMain.getSnapValue();
            int size = Math.max(mx - this.grabbed.field_146128_h, my - this.grabbed.field_146129_i);
            int mult = Math.max(1, (int)Math.ceil((float)size / (float)snap));
            this.grabbed.field_146120_f = size = mult * snap;
            this.grabbed.field_146121_g = size;
        }
        ToolboxGuiMain.drawGrid(this.gui);
    }

    @Override
    public void onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.grabbed != null) {
            IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getQuestLine().getValue(this.grabID);
            if (qle != null) {
                this.grabbed.field_146120_f = qle.getSize();
                this.grabbed.field_146121_g = qle.getSize();
            }
            this.grabbed = null;
            this.grabID = -1;
            return;
        }
        if (click != 0) {
            return;
        }
        if (this.grabbed == null) {
            this.grabbed = this.gui.getQuestLine().getButtonAt(mx, my);
            this.grabID = this.grabbed == null ? -1 : QuestDatabase.INSTANCE.getID(this.grabbed.getQuest());
        } else {
            IQuestLine qLine = this.gui.getQuestLine().getQuestLine();
            int lID = QuestLineDatabase.INSTANCE.getID(qLine);
            IQuestLineEntry qle = (IQuestLineEntry)this.gui.getQuestLine().getQuestLine().getValue(this.grabID);
            if (qle != null) {
                qle.setSize(Math.max(this.grabbed.field_146120_f, this.grabbed.field_146121_g));
                NBTTagCompound tag2 = new NBTTagCompound();
                NBTTagCompound base2 = new NBTTagCompound();
                base2.func_74782_a("line", (NBTBase)qLine.writeToNBT(new NBTTagCompound(), null));
                tag2.func_74782_a("data", (NBTBase)base2);
                tag2.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
                tag2.func_74768_a("lineID", lID);
                PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tag2));
            }
            this.grabbed = null;
            this.grabID = -1;
        }
    }

    @Override
    public void onMouseScroll(int mx, int my, int scroll) {
    }

    @Override
    public void onKeyPressed(char c, int key) {
    }

    @Override
    public boolean allowTooltips() {
        return this.grabbed == null;
    }

    @Override
    public boolean allowScrolling(int click) {
        return this.grabbed == null || click == 2;
    }

    @Override
    public boolean allowZoom() {
        return true;
    }

    @Override
    public boolean clampScrolling() {
        return true;
    }
}

