/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.gui.controls.GuiButtonQuestInstance;
import betterquesting.api.client.gui.misc.IGuiQuestLine;
import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.enums.EnumPacketAction;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.client.toolbox.ToolboxGuiMain;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeNative;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestInstance;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ToolboxToolNew
implements IToolboxTool {
    IGuiQuestLine gui = null;
    GuiButtonQuestInstance nQuest;

    @Override
    public void initTool(IGuiQuestLine gui) {
        this.gui = gui;
        this.nQuest = new GuiButtonQuestInstance(0, 0, 0, 24, 24, new QuestInstance());
    }

    @Override
    public void drawTool(int mx, int my, float partialTick) {
        if (this.nQuest == null) {
            return;
        }
        int snap = ToolboxGuiMain.getSnapValue();
        int modX = (mx % snap + snap) % snap;
        int modY = (my % snap + snap) % snap;
        this.nQuest.field_146128_h = mx -= modX;
        this.nQuest.field_146129_i = my -= modY;
        this.nQuest.func_191745_a(Minecraft.func_71410_x(), mx, my, partialTick);
        ToolboxGuiMain.drawGrid(this.gui);
    }

    @Override
    public void disableTool() {
        if (this.nQuest != null) {
            this.gui.getQuestLine().getButtonTree().remove((Object)this.nQuest);
            this.nQuest = null;
        }
    }

    @Override
    public void onMouseClick(int mx, int my, int click) {
        if (click != 0) {
            return;
        }
        int snap = ToolboxGuiMain.getSnapValue();
        int modX = (mx % snap + snap) % snap;
        int modY = (my % snap + snap) % snap;
        mx -= modX;
        my -= modY;
        IQuestLine qLine = this.gui.getQuestLine().getQuestLine();
        QuestInstance quest = new QuestInstance();
        int qID = QuestDatabase.INSTANCE.nextID();
        int lID = QuestLineDatabase.INSTANCE.getID(qLine);
        IQuestLineEntry qe = (IQuestLineEntry)qLine.getValue(qID);
        if (qe == null) {
            qe = new QuestLineEntry(mx, my, 24);
            qLine.add(qID, qe);
        } else {
            qe.setPosition(mx, my);
            qe.setSize(24);
        }
        NBTTagCompound tag1 = new NBTTagCompound();
        NBTTagCompound base1 = new NBTTagCompound();
        base1.func_74782_a("config", (NBTBase)quest.writeToNBT(new NBTTagCompound()));
        tag1.func_74782_a("data", (NBTBase)base1);
        tag1.func_74768_a("action", EnumPacketAction.ADD.ordinal());
        tag1.func_74768_a("questID", qID);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.QUEST_EDIT.GetLocation(), tag1));
        NBTTagCompound tag2 = new NBTTagCompound();
        NBTTagCompound base2 = new NBTTagCompound();
        base2.func_74782_a("line", (NBTBase)qLine.writeToNBT(new NBTTagCompound(), null));
        tag2.func_74782_a("data", (NBTBase)base2);
        tag2.func_74768_a("action", EnumPacketAction.EDIT.ordinal());
        tag2.func_74768_a("lineID", lID);
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(PacketTypeNative.LINE_EDIT.GetLocation(), tag2));
    }

    @Override
    public void onMouseScroll(int mx, int my, int scroll) {
    }

    @Override
    public void onKeyPressed(char c, int keyCode) {
    }

    @Override
    public boolean allowTooltips() {
        return false;
    }

    @Override
    public boolean allowScrolling(int click) {
        return click == 2;
    }

    @Override
    public boolean allowZoom() {
        return true;
    }

    @Override
    public boolean clampScrolling() {
        return false;
    }
}

