/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.content.PanelGeneric;
import betterquesting.api2.client.gui.panels.content.PanelLine;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import betterquesting.api2.client.gui.resources.textures.GuiTextureColored;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.resources.textures.SimpleTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.storage.DBEntry;
import betterquesting.questing.QuestDatabase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class CanvasQuestLine
extends CanvasScrolling {
    private final int buttonId;

    public CanvasQuestLine(IGuiRect rect, int buttonId) {
        super(rect);
        this.setupAdvanceScroll(true, true, 24);
        this.buttonId = buttonId;
    }

    public void setQuestLine(IQuestLine line) {
        EnumQuestState qState;
        this.resetCanvas();
        if (line == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        UUID pid = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        String bgString = line.getProperties().getProperty(NativeProps.BG_IMAGE);
        if (bgString != null && bgString.length() > 0) {
            ResourceLocation bgRes = new ResourceLocation(bgString);
            int bgSize = line.getProperties().getProperty(NativeProps.BG_SIZE);
            this.addPanel(new PanelGeneric(new GuiRectangle(0, 0, bgSize, bgSize), new SimpleTexture(bgRes, new GuiRectangle(0, 0, 256, 256))));
        }
        boolean flag = false;
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        HashMap<Integer, PanelButtonStorage<IQuest>> questBtns = new HashMap<Integer, PanelButtonStorage<IQuest>>();
        for (DBEntry qle : line.getEntries()) {
            IQuest quest = (IQuest)QuestDatabase.INSTANCE.getValue(qle.getID());
            if (!CanvasQuestLine.isQuestShown(quest, pid)) continue;
            qState = quest.getState(pid);
            IGuiTexture txFrame = null;
            IGuiColor txIconCol = null;
            boolean main = quest.getProperty(NativeProps.MAIN);
            boolean lock = false;
            switch (qState) {
                case LOCKED: {
                    txFrame = main ? PresetTexture.QUEST_MAIN_0.getTexture() : PresetTexture.QUEST_NORM_0.getTexture();
                    txIconCol = PresetColor.QUEST_ICON_LOCKED.getColor();
                    lock = true;
                    break;
                }
                case UNLOCKED: {
                    txFrame = main ? PresetTexture.QUEST_MAIN_1.getTexture() : PresetTexture.QUEST_NORM_1.getTexture();
                    txIconCol = PresetColor.QUEST_ICON_UNLOCKED.getColor();
                    break;
                }
                case UNCLAIMED: {
                    txFrame = main ? PresetTexture.QUEST_MAIN_2.getTexture() : PresetTexture.QUEST_NORM_2.getTexture();
                    txIconCol = PresetColor.QUEST_ICON_PENDING.getColor();
                    break;
                }
                case COMPLETED: {
                    txFrame = main ? PresetTexture.QUEST_MAIN_3.getTexture() : PresetTexture.QUEST_NORM_3.getTexture();
                    txIconCol = PresetColor.QUEST_ICON_COMPLETE.getColor();
                }
            }
            GuiRectangle rect = new GuiRectangle(((IQuestLineEntry)qle.getValue()).getPosX(), ((IQuestLineEntry)qle.getValue()).getPosY(), ((IQuestLineEntry)qle.getValue()).getSize(), ((IQuestLineEntry)qle.getValue()).getSize());
            PanelButtonStorage<IQuest> paBtn = new PanelButtonStorage<IQuest>(rect, this.buttonId, "", quest);
            GuiTextureColored btnTx = new GuiTextureColored(txFrame, txIconCol);
            paBtn.setTextures(btnTx, btnTx, btnTx);
            paBtn.setIcon(new OreDictTexture(1.0f, quest.getProperty(NativeProps.ICON), false, true), 4);
            paBtn.setTooltip(quest.getTooltip((EntityPlayer)player));
            paBtn.setActive(QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)player) || !lock);
            this.addPanel(paBtn);
            questBtns.put(qle.getID(), paBtn);
            if (!flag) {
                minX = rect.getX();
                minY = rect.getY();
                maxX = minX + rect.getWidth();
                maxY = minY + rect.getHeight();
                flag = true;
                continue;
            }
            minX = Math.min(minX, rect.getX());
            minY = Math.min(minY, rect.getY());
            maxX = Math.max(maxX, rect.getX() + rect.getWidth());
            maxY = Math.max(maxY, rect.getY() + rect.getHeight());
        }
        for (Map.Entry entry : questBtns.entrySet()) {
            IQuest quest = (IQuest)((PanelButtonStorage)entry.getValue()).getStoredValue();
            List<IQuest> reqList = quest.getPrerequisites();
            if (reqList.size() <= 0) continue;
            boolean main = quest.getProperty(NativeProps.MAIN);
            qState = quest.getState(pid);
            IGuiLine lineRender = null;
            IGuiColor txLineCol = null;
            switch (qState) {
                case LOCKED: {
                    lineRender = PresetLine.QUEST_LOCKED.getLine();
                    txLineCol = PresetColor.QUEST_LINE_LOCKED.getColor();
                    break;
                }
                case UNLOCKED: {
                    lineRender = PresetLine.QUEST_UNLOCKED.getLine();
                    txLineCol = PresetColor.QUEST_LINE_UNLOCKED.getColor();
                    break;
                }
                case UNCLAIMED: {
                    lineRender = PresetLine.QUEST_PENDING.getLine();
                    txLineCol = PresetColor.QUEST_LINE_PENDING.getColor();
                    break;
                }
                case COMPLETED: {
                    lineRender = PresetLine.QUEST_COMPLETE.getLine();
                    txLineCol = PresetColor.QUEST_LINE_COMPLETE.getColor();
                }
            }
            for (IQuest req : reqList) {
                int id = QuestDatabase.INSTANCE.getID(req);
                PanelButtonStorage parBtn = (PanelButtonStorage)questBtns.get(id);
                if (parBtn == null) continue;
                PanelLine prLine = new PanelLine(parBtn.getTransform(), ((PanelButtonStorage)entry.getValue()).getTransform(), lineRender, main ? 8 : 4, txLineCol, 1);
                this.addPanel(prLine);
            }
        }
        float frameW = this.getTransform().getWidth();
        float f = this.getTransform().getHeight();
        if (frameW <= 0.0f || f <= 0.0f) {
            return;
        }
        float scale = Math.min(frameW / (float)((maxX += this.margin) - (minX -= this.margin)), f / (float)((maxY += this.margin) - (minY -= this.margin)));
        scale = MathHelper.func_76131_a((float)scale, (float)0.25f, (float)2.0f);
        this.setZoom(scale);
        int scrollX = Math.round((float)(maxX - minX) / 2.0f - frameW / scale / 2.0f);
        int scrollY = Math.round((float)(maxY - minY) / 2.0f - f / scale / 2.0f);
        this.setScrollX(scrollX);
        this.setScrollY(scrollY);
    }

    public static boolean isQuestShown(IQuest quest, UUID uuid) {
        if (quest == null || uuid == null) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EnumQuestVisibility vis = quest.getProperty(NativeProps.VISIBILITY);
        if (QuestingAPI.getAPI(ApiReference.SETTINGS).canUserEdit((EntityPlayer)mc.field_71439_g) || vis == EnumQuestVisibility.ALWAYS) {
            return true;
        }
        if (vis == EnumQuestVisibility.HIDDEN) {
            return false;
        }
        if (vis == EnumQuestVisibility.UNLOCKED) {
            return quest.isComplete(uuid) || quest.isUnlocked(uuid);
        }
        if (vis == EnumQuestVisibility.NORMAL) {
            if (quest.isComplete(uuid) || quest.isUnlocked(uuid)) {
                return true;
            }
            for (IQuest q : quest.getPrerequisites()) {
                if (q.isUnlocked(uuid)) continue;
                return false;
            }
            return true;
        }
        if (vis == EnumQuestVisibility.COMPLETED) {
            return quest.isComplete(uuid);
        }
        if (vis == EnumQuestVisibility.CHAIN) {
            if (quest.getPrerequisites().size() <= 0) {
                return true;
            }
            for (IQuest q : quest.getPrerequisites()) {
                if (!CanvasQuestLine.isQuestShown(q, uuid)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

