/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.themes;

import betterquesting.api.client.themes.ITheme;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.lines.IGuiLine;
import betterquesting.api2.client.gui.resources.lines.SimpleLine;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.resources.textures.SlicedTexture;
import betterquesting.api2.client.gui.themes.IGuiTheme;
import betterquesting.api2.client.gui.themes.LegacyThemeWrapper;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.client.gui.themes.presets.PresetLine;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ThemeRegistry {
    public static final ThemeRegistry INSTANCE = new ThemeRegistry();
    private static final IGuiTexture NULL_TEXTURE = new SlicedTexture(PresetTexture.TX_NULL, new GuiRectangle(0, 0, 32, 32), new GuiPadding(8, 8, 8, 8));
    private static final IGuiLine NULL_LINE = new SimpleLine();
    private static final IGuiColor NULL_COLOR = new GuiColorStatic(Color.BLACK);
    private final HashMap<ResourceLocation, IGuiTexture> defTextures = new HashMap();
    private final HashMap<ResourceLocation, IGuiLine> defLines = new HashMap();
    private final HashMap<ResourceLocation, IGuiColor> defColors = new HashMap();
    private final HashMap<ResourceLocation, IGuiTheme> themes = new HashMap();
    private IGuiTheme activeTheme = null;

    private ThemeRegistry() {
        PresetTexture.registerTextures(this);
        PresetIcon.registerIcons(this);
        PresetLine.registerLines(this);
        PresetColor.registerColors(this);
    }

    public void registerTheme(IGuiTheme theme) {
        if (theme == null || theme.getID() == null) {
            throw new NullPointerException("Cannot register null theme");
        }
        if (this.themes.containsKey(theme.getID())) {
            throw new IllegalArgumentException("Cannot register duplicate theme: " + theme.getID());
        }
        this.themes.put(theme.getID(), theme);
    }

    public void setDefaultTexture(ResourceLocation key, IGuiTexture tex) {
        if (key == null || tex == null) {
            throw new IllegalArgumentException("Tried to register a texture with one or more NULL arguments");
        }
        if (this.defTextures.containsKey(key)) {
            throw new IllegalArgumentException("Tried to overwrite existing default texture: " + key);
        }
        this.defTextures.put(key, tex);
    }

    public void setDefaultLine(ResourceLocation key, IGuiLine line) {
        if (key == null || line == null) {
            throw new IllegalArgumentException("Tried to register a line with one or more NULL arguments");
        }
        if (this.defTextures.containsKey(key)) {
            throw new IllegalArgumentException("Tried to overwrite existing default line: " + key);
        }
        this.defLines.put(key, line);
    }

    public void setDefaultColor(ResourceLocation key, IGuiColor color) {
        if (this.defTextures.containsKey(key)) {
            throw new IllegalArgumentException("Tried to overwrite existing default color: " + key);
        }
        this.defColors.put(key, color);
    }

    public void setTheme(ResourceLocation id) {
        this.setTheme(this.themes.get(id));
    }

    public void setTheme(IGuiTheme theme) {
        this.activeTheme = theme;
    }

    public IGuiTheme getCurrentTheme() {
        return this.activeTheme;
    }

    public IGuiTexture getTexture(ResourceLocation key) {
        if (key == null) {
            return NULL_TEXTURE;
        }
        IGuiTexture tex = null;
        ITheme legTheme = betterquesting.client.themes.ThemeRegistry.INSTANCE.getCurrentTheme();
        if (!(legTheme == null || this.activeTheme != null && this.activeTheme.getID().equals((Object)legTheme.getThemeID()))) {
            this.activeTheme = new LegacyThemeWrapper(legTheme);
        }
        if (this.activeTheme != null) {
            tex = this.activeTheme.getTexture(key);
        }
        tex = tex != null ? tex : this.defTextures.get(key);
        return tex == null ? NULL_TEXTURE : tex;
    }

    public IGuiLine getLineRenderer(ResourceLocation key) {
        if (key == null) {
            return NULL_LINE;
        }
        IGuiLine line = null;
        ITheme legTheme = betterquesting.client.themes.ThemeRegistry.INSTANCE.getCurrentTheme();
        if (!(legTheme == null || this.activeTheme != null && this.activeTheme.getID().equals((Object)legTheme.getThemeID()))) {
            this.activeTheme = new LegacyThemeWrapper(legTheme);
        }
        if (this.activeTheme != null) {
            line = this.activeTheme.getLine(key);
        }
        line = line != null ? line : this.defLines.get(key);
        return line == null ? NULL_LINE : line;
    }

    public IGuiColor getColor(ResourceLocation key) {
        if (key == null) {
            return NULL_COLOR;
        }
        IGuiColor color = null;
        ITheme legTheme = betterquesting.client.themes.ThemeRegistry.INSTANCE.getCurrentTheme();
        if (!(legTheme == null || this.activeTheme != null && this.activeTheme.getID().equals((Object)legTheme.getThemeID()))) {
            this.activeTheme = new LegacyThemeWrapper(legTheme);
        }
        if (this.activeTheme != null) {
            color = this.activeTheme.getColor(key);
        }
        color = color != null ? color : this.defColors.get(key);
        return color == null ? NULL_COLOR : color;
    }

    public List<IGuiTheme> getAllThemes() {
        return new ArrayList<IGuiTheme>(this.themes.values());
    }

    public List<ResourceLocation> getAllThemeIDs() {
        return new ArrayList<ResourceLocation>(this.themes.keySet());
    }
}

