/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class ItemTexture
implements IGuiTexture {
    private static final IGuiColor defColor = new GuiColorStatic(255, 255, 255, 255);
    private final BigItemStack stack;
    private final boolean showCount;
    private final boolean keepAspect;
    private float zDepth = 16.0f;
    private final IGuiRect bounds = new GuiRectangle(0, 0, 16, 16);

    public ItemTexture(BigItemStack stack) {
        this(stack, false, true);
    }

    public ItemTexture(BigItemStack stack, boolean showCount, boolean keepAspect) {
        this.stack = stack;
        this.showCount = showCount;
        this.keepAspect = keepAspect;
    }

    public ItemTexture setDepth(float z) {
        this.zDepth = z;
        return this;
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zLevel, float partialTick) {
        this.drawTexture(x, y, width, height, zLevel, partialTick, defColor);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zLevel, float partialTick, IGuiColor color) {
        float sx = (float)width / 16.0f;
        float sy = (float)height / 16.0f;
        double dx = 0.0;
        double dy = 0.0;
        if (this.keepAspect) {
            float sa = Math.min(sx, sy);
            dx = Math.floor((sx - sa) * 8.0f);
            dy = Math.floor((sy - sa) * 8.0f);
            sx = sa;
            sy = sa;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)x + dx), (double)((double)y + dy), (double)0.0);
        GlStateManager.func_179152_a((float)sx, (float)sy, (float)1.0f);
        color.applyGlColor();
        RenderUtils.RenderItemStack(Minecraft.func_71410_x(), this.stack.getBaseStack(), 0, 0, this.zDepth, this.showCount && this.stack.stackSize > 1 ? "" + this.stack.stackSize : "", -1);
        GlStateManager.func_179121_F();
    }

    @Override
    public ResourceLocation getTexture() {
        return PresetTexture.TX_NULL;
    }

    @Override
    public IGuiRect getBounds() {
        return this.bounds;
    }
}

