/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.colors;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import net.minecraft.client.renderer.GlStateManager;

public class GuiColorPulse
implements IGuiColor {
    private static final double RAD = Math.toRadians(360.0);
    private final int c1;
    private final int c2;
    private final double period;
    private final float phase;

    public GuiColorPulse(int color1, int color2, double period, float phase) {
        this.c1 = color1;
        this.c2 = color2;
        this.period = period;
        this.phase = phase;
    }

    @Override
    public int getRGB() {
        double pms = 1000.0 * this.period;
        double time = (double)System.currentTimeMillis() % pms;
        time = (time + pms * (double)this.phase) % pms / pms;
        float blend = (float)(Math.cos(time * RAD) / 2.0 + 0.5);
        return RenderUtils.lerpRGB(this.c1, this.c2, blend);
    }

    @Override
    public float getRed() {
        return (float)(this.getRGB() >> 16 & 0xFF) / 255.0f;
    }

    @Override
    public float getGreen() {
        return (float)(this.getRGB() >> 8 & 0xFF) / 255.0f;
    }

    @Override
    public float getBlue() {
        return (float)(this.getRGB() & 0xFF) / 255.0f;
    }

    @Override
    public float getAlpha() {
        return (float)(this.getRGB() >> 24 & 0xFF) / 255.0f;
    }

    @Override
    public void applyGlColor() {
        int color = this.getRGB();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }
}

