/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.lists;

import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.lists.CanvasSearch;
import java.util.ArrayDeque;
import java.util.Iterator;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CanvasEntityDatabase
extends CanvasSearch<EntityEntry, EntityEntry> {
    private final int btnId;

    public CanvasEntityDatabase(IGuiRect rect, int buttonId) {
        super(rect);
        this.btnId = buttonId;
    }

    @Override
    protected Iterator<EntityEntry> getIterator() {
        return ForgeRegistries.ENTITIES.iterator();
    }

    @Override
    protected void queryMatches(EntityEntry ee, String query, ArrayDeque<EntityEntry> results) {
        if (ee == null || ee.getRegistryName() == null) {
            return;
        }
        if (ee.getRegistryName().toString().toLowerCase().contains(query) || ee.getName().toLowerCase().contains(query) || ee.getEntityClass().toString().toLowerCase().contains(query)) {
            results.add(ee);
        }
    }

    @Override
    protected boolean addResult(EntityEntry ee, int index, int cachedWidth) {
        if (ee == null) {
            return false;
        }
        this.addPanel(new PanelButtonStorage<EntityEntry>(new GuiRectangle(0, index * 16, cachedWidth, 16, 0), this.btnId, ee.getName(), ee));
        return true;
    }
}

