/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.EntityPlayerPreview;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PanelPlayerPortrait
implements IGuiPanel {
    private final IGuiRect transform;
    private boolean enabled = true;
    private final AbstractClientPlayer player;
    private final IValueIO<Float> basePitch;
    private final IValueIO<Float> baseYaw;
    private IValueIO<Float> pitchDriver;
    private IValueIO<Float> yawDriver;
    private float zDepth = 100.0f;

    public PanelPlayerPortrait(IGuiRect rect, UUID playerID, String username) {
        this(rect, (AbstractClientPlayer)new EntityPlayerPreview((World)Minecraft.func_71410_x().field_71441_e, new GameProfile(playerID, username)));
    }

    public PanelPlayerPortrait(IGuiRect rect, AbstractClientPlayer player) {
        this.transform = rect;
        this.player = new EntityPlayerPreview(player.field_70170_p, player.func_146103_bH());
        this.player.field_184619_aG = 0.0f;
        this.player.field_70721_aZ = 0.0f;
        this.player.field_70759_as = 0.0f;
        ResourceLocation resource = this.player.func_110306_p();
        if (Minecraft.func_71410_x().func_110434_K().func_110581_b(resource) == null) {
            AbstractClientPlayer.func_110304_a((ResourceLocation)resource, (String)player.func_146103_bH().getName());
        }
        this.basePitch = new IValueIO<Float>(){
            private float val = 15.0f;

            @Override
            public Float readValue() {
                return Float.valueOf(this.val);
            }

            @Override
            public void writeValue(Float value) {
                this.val = value.floatValue();
            }
        };
        this.pitchDriver = this.basePitch;
        this.baseYaw = new IValueIO<Float>(){
            private float val = -30.0f;

            @Override
            public Float readValue() {
                return Float.valueOf(this.val);
            }

            @Override
            public void writeValue(Float value) {
                this.val = value.floatValue();
            }
        };
        this.yawDriver = this.baseYaw;
    }

    public PanelPlayerPortrait setRotationFixed(float pitch, float yaw) {
        this.pitchDriver = this.basePitch;
        this.yawDriver = this.baseYaw;
        this.basePitch.writeValue(Float.valueOf(pitch));
        this.baseYaw.writeValue(Float.valueOf(yaw));
        return this;
    }

    public PanelPlayerPortrait setRotationDriven(IValueIO<Float> pitch, IValueIO<Float> yaw) {
        this.pitchDriver = pitch == null ? this.basePitch : pitch;
        this.yawDriver = yaw == null ? this.baseYaw : yaw;
        return this;
    }

    public PanelPlayerPortrait setDepth(float z) {
        this.zDepth = z;
        return this;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        IGuiRect bounds = this.getTransform();
        GlStateManager.func_179094_E();
        RenderUtils.startScissor(new GuiRectangle(bounds));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scale = Math.min(bounds.getWidth(), bounds.getHeight());
        RenderUtils.RenderEntity(bounds.getX() + bounds.getWidth() / 2, bounds.getY() + bounds.getHeight() / 2 + (int)((float)scale * 1.5f), this.zDepth, scale, this.yawDriver.readValue().floatValue(), this.pitchDriver.readValue().floatValue(), (Entity)this.player);
        RenderUtils.endScissor();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }
}

