/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.bars;

import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.bars.IScrollBar;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;

public class PanelHScrollBar
implements IScrollBar {
    private final IGuiRect transform;
    private boolean enabled = true;
    private boolean active = true;
    private IGuiTexture texBack;
    private IGuiTexture[] texHandleState = new IGuiTexture[3];
    private float scroll = 0.0f;
    private float speed = 0.1f;
    private int hSize = 16;
    private int inset = 0;
    private boolean isDragging = false;

    public PanelHScrollBar(IGuiRect rect) {
        this.transform = rect;
        this.setBarTexture(PresetTexture.SCROLL_H_BG.getTexture(), PresetTexture.SCROLL_H_0.getTexture(), PresetTexture.SCROLL_H_1.getTexture(), PresetTexture.SCROLL_H_2.getTexture());
    }

    @Override
    public PanelHScrollBar setHandleSize(int size, int inset) {
        this.hSize = size;
        this.inset = inset;
        return this;
    }

    @Override
    public PanelHScrollBar setBarTexture(IGuiTexture back, IGuiTexture handleDisabled, IGuiTexture handleIdle, IGuiTexture handleHover) {
        this.texBack = back;
        this.texHandleState[0] = handleDisabled;
        this.texHandleState[1] = handleIdle;
        this.texHandleState[2] = handleHover;
        return this;
    }

    @Override
    public PanelHScrollBar setScrollSpeed(float f) {
        this.speed = f;
        return this;
    }

    @Override
    public void initPanel() {
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setActive(boolean state) {
        this.active = state;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        IGuiRect bounds = this.getTransform();
        if (this.active && this.isDragging && (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)2))) {
            float cx = (float)(mx - (bounds.getX() + this.hSize / 2)) / (float)(bounds.getWidth() - this.hSize);
            this.writeValue(Float.valueOf(cx));
        } else if (this.isDragging) {
            this.isDragging = false;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.texBack != null) {
            this.texBack.drawTexture(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 0.0f, partialTick);
        }
        int sx = MathHelper.func_76141_d((float)((float)(bounds.getWidth() - this.hSize - this.inset * 2) * this.scroll));
        int state = !this.active ? 0 : (this.isDragging || bounds.contains(mx, my) ? 2 : 1);
        IGuiTexture tex = this.texHandleState[state];
        if (tex != null) {
            tex.drawTexture(bounds.getX() + sx + this.inset, bounds.getY() + this.inset, this.hSize, bounds.getHeight() - this.inset * 2, 0.0f, partialTick);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        IGuiRect bounds = this.getTransform();
        if (!this.active || !bounds.contains(mx, my)) {
            return false;
        }
        if (click == 0 || click == 2) {
            this.isDragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int sdx) {
        IGuiRect bounds = this.getTransform();
        if (!this.active || sdx == 0 || !bounds.contains(mx, my)) {
            return false;
        }
        float dx = (float)sdx * this.speed;
        if (dx < 0.0f && this.scroll <= 0.0f || dx > 0.0f && this.scroll >= 1.0f) {
            return false;
        }
        this.writeValue(Float.valueOf(dx + this.scroll));
        return true;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        return false;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return null;
    }

    @Override
    public Float readValue() {
        return Float.valueOf(this.scroll);
    }

    @Override
    public void writeValue(Float value) {
        this.scroll = MathHelper.func_76131_a((float)value.floatValue(), (float)0.0f, (float)1.0f);
    }
}

