/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui;

import betterquesting.api.client.gui.GuiYesNoLocked;
import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.ComparatorGuiDepth;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.BQ_Keybindings;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiScreenCanvas
extends GuiScreen
implements IGuiCanvas {
    private final List<IGuiPanel> guiPanels = new CopyOnWriteArrayList<IGuiPanel>();
    private final GuiRectangle transform = new GuiRectangle(0, 0, 0, 0, 0);
    private boolean enabled = true;
    public final GuiScreen parent;
    private boolean[] mBtnState = new boolean[3];

    public GuiScreenCanvas(GuiScreen parent) {
        this.parent = parent;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    public final void func_73866_w_() {
        super.func_73866_w_();
        this.initPanel();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void initPanel() {
        int marginX = 16;
        int marginY = 16;
        if (BQ_Settings.guiWidth > 0) {
            marginX = Math.max(16, (this.field_146294_l - BQ_Settings.guiWidth) / 2);
        }
        if (BQ_Settings.guiHeight > 0) {
            marginY = Math.max(16, (this.field_146295_m - BQ_Settings.guiHeight) / 2);
        }
        this.transform.x = marginX;
        this.transform.y = marginY;
        this.transform.w = this.field_146294_l - marginX * 2;
        this.transform.h = this.field_146295_m - marginY * 2;
        this.guiPanels.clear();
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public final void func_73863_a(int mx, int my, float partialTick) {
        super.func_73863_a(mx, my, partialTick);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        this.drawPanel(mx, my, partialTick);
        List<String> tt = this.getTooltip(mx, my);
        if (tt != null && tt.size() > 0) {
            this.func_146283_a(tt, mx, my);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    @Deprecated
    public void func_146284_a(GuiButton button) {
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int k = Mouse.getEventButton();
        int SDX = (int)(-Math.signum(Mouse.getEventDWheel()));
        boolean flag = Mouse.getEventButtonState();
        if (k >= 0 && k < 3 && this.mBtnState[k] != flag) {
            if (flag) {
                this.onMouseClick(i, j, k);
            } else {
                this.onMouseRelease(i, j, k);
            }
            this.mBtnState[k] = flag;
        }
        if (SDX != 0) {
            this.onMouseScroll(i, j, SDX);
        }
    }

    public void func_73869_a(char c, int keyCode) throws IOException {
        if (keyCode == 1) {
            if (this instanceof IVolatileScreen) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNoLocked((GuiYesNoCallback)this, QuestTranslation.translate("betterquesting.gui.closing_warning", new Object[0]), QuestTranslation.translate("betterquesting.gui.closing_confirm", new Object[0]), 0));
            } else {
                this.field_146297_k.func_147108_a(null);
                if (this.field_146297_k.field_71462_r == null) {
                    this.field_146297_k.func_71381_h();
                }
            }
            return;
        }
        this.onKeyTyped(c, keyCode);
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        for (IGuiPanel entry : this.guiPanels) {
            if (!entry.isEnabled()) continue;
            entry.drawPanel(mx, my, partialTick);
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseClick(mx, my, click)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseRelease(mx, my, click)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseScroll(mx, my, scroll)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onKeyTyped(c, keycode)) continue;
            used = true;
            break;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!used && (BQ_Keybindings.openQuests.func_151468_f() || mc.field_71474_y.field_151445_Q.func_151468_f())) {
            mc.func_147108_a(this.parent);
        }
        return used;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            List<String> tt;
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || (tt = entry.getTooltip(mx, my)) == null) continue;
            return tt;
        }
        return null;
    }

    @Override
    public void addPanel(IGuiPanel panel) {
        if (panel == null || this.guiPanels.contains(panel)) {
            return;
        }
        this.guiPanels.add(panel);
        this.guiPanels.sort(ComparatorGuiDepth.INSTANCE);
        panel.getTransform().setParent(this.getTransform());
        panel.initPanel();
    }

    @Override
    public boolean removePanel(IGuiPanel panel) {
        return this.guiPanels.remove(panel);
    }

    @Override
    public void resetCanvas() {
        this.guiPanels.clear();
    }

    public boolean func_73868_f() {
        return false;
    }

    @Deprecated
    public <T extends GuiButton> T func_189646_b(T button) {
        return (T)super.func_189646_b(button);
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        RenderUtils.drawHoveringText(stack, this.func_191927_a(stack), x, y, this.field_146294_l, this.field_146295_m, -1, font == null ? this.field_146289_q : font);
    }

    protected void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        RenderUtils.drawHoveringText(textLines, x, y, this.field_146294_l, this.field_146295_m, -1, font);
    }

    public void func_73878_a(boolean confirmed, int id) {
        if (confirmed && id == 0) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else {
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }
}

