/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;

public final class WorldUtil {
    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract) {
        return WorldUtil.doItemInteraction(extractWrapper, insertWrapper, maxExtract, null);
    }

    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract, FilterSettings filter) {
        return WorldUtil.doItemInteraction(extractWrapper, insertWrapper, maxExtract, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, filter);
    }

    public static boolean doItemInteraction(SlotlessableItemHandlerWrapper extractWrapper, SlotlessableItemHandlerWrapper insertWrapper, int maxExtract, int extractSlotStart, int extractSlotEnd, int insertSlotStart, int insertSlotEnd, FilterSettings filter) {
        ItemStack remaining;
        ItemStack theoreticalExtract = WorldUtil.extractItem(extractWrapper, maxExtract, true, extractSlotStart, extractSlotEnd, filter);
        if (StackUtil.isValid(theoreticalExtract) && !ItemStack.func_77989_b((ItemStack)(remaining = StackUtil.insertItem(insertWrapper, theoreticalExtract, false, insertSlotStart, insertSlotEnd)), (ItemStack)theoreticalExtract)) {
            int toExtract = theoreticalExtract.func_190916_E() - remaining.func_190916_E();
            WorldUtil.extractItem(extractWrapper, toExtract, false, extractSlotStart, extractSlotEnd, filter);
            return true;
        }
        return false;
    }

    public static ItemStack extractItem(SlotlessableItemHandlerWrapper extractWrapper, int maxExtract, boolean simulate, int slotStart, int slotEnd, FilterSettings filter) {
        Object handler;
        ItemStack extracted = StackUtil.getEmpty();
        if (ActuallyAdditions.commonCapsLoaded && (handler = extractWrapper.getSlotlessHandler()) instanceof ISlotlessItemHandler) {
            ISlotlessItemHandler slotless = (ISlotlessItemHandler)handler;
            if (filter == null || !filter.needsCheck()) {
                extracted = slotless.extractItem(maxExtract, simulate);
                return extracted;
            }
            ItemStack would = slotless.extractItem(maxExtract, true);
            if (filter.check(would)) {
                extracted = simulate ? would : slotless.extractItem(maxExtract, false);
            }
        }
        if (!StackUtil.isValid(extracted) && (handler = extractWrapper.getNormalHandler()) != null) {
            for (int i = Math.max(0, slotStart); i < Math.min(slotEnd, handler.getSlots()) && (filter != null && filter.needsCheck() && !filter.check(handler.getStackInSlot(i)) || !StackUtil.isValid(extracted = handler.extractItem(i, maxExtract, simulate))); ++i) {
            }
        }
        return extracted;
    }

    public static void doEnergyInteraction(TileEntity tileFrom, TileEntity tileTo, EnumFacing sideTo, int maxTransfer) {
        if (maxTransfer > 0) {
            int drain;
            EnumFacing opp = sideTo == null ? null : sideTo.func_176734_d();
            IEnergyStorage handlerFrom = (IEnergyStorage)tileFrom.getCapability(CapabilityEnergy.ENERGY, sideTo);
            IEnergyStorage handlerTo = (IEnergyStorage)tileTo.getCapability(CapabilityEnergy.ENERGY, opp);
            if (handlerFrom != null && handlerTo != null && (drain = handlerFrom.extractEnergy(maxTransfer, true)) > 0) {
                int filled = handlerTo.receiveEnergy(drain, false);
                handlerFrom.extractEnergy(filled, false);
                return;
            }
        }
    }

    public static void doFluidInteraction(TileEntity tileFrom, TileEntity tileTo, EnumFacing sideTo, int maxTransfer) {
        if (maxTransfer > 0 && tileFrom.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo) && tileTo.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo.func_176734_d())) {
            IFluidHandler handlerFrom = (IFluidHandler)tileFrom.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo);
            IFluidHandler handlerTo = (IFluidHandler)tileTo.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo.func_176734_d());
            FluidStack drain = handlerFrom.drain(maxTransfer, false);
            if (drain != null) {
                int filled = handlerTo.fill(drain.copy(), true);
                handlerFrom.drain(filled, true);
            }
        }
    }

    public static boolean hasBlocksInPlacesGiven(BlockPos[] positions, Block block, int meta, World world) {
        for (BlockPos pos : positions) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == block && block.func_176201_c(state) == meta) continue;
            return false;
        }
        return true;
    }

    public static ItemStack useItemAtSide(EnumFacing side, World world, BlockPos pos, ItemStack stack) {
        if (world instanceof WorldServer && StackUtil.isValid(stack) && pos != null) {
            BlockPos offsetPos = pos.func_177972_a(side);
            IBlockState state = world.func_180495_p(offsetPos);
            Block block = state.func_177230_c();
            boolean replaceable = block.func_176200_f((IBlockAccess)world, offsetPos);
            if (replaceable && stack.func_77973_b() == Items.field_151137_ax) {
                world.func_180501_a(offsetPos, Blocks.field_150488_af.func_176223_P(), 2);
                return StackUtil.shrink(stack, 1);
            }
            if (replaceable && stack.func_77973_b() instanceof IPlantable && ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, offsetPos).func_177230_c().func_176196_c(world, offsetPos) && world.func_180501_a(offsetPos, ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, offsetPos), 2)) {
                return StackUtil.shrink(stack, 1);
            }
            try {
                FakePlayer fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
                ItemStack heldBefore = fake.func_184614_ca();
                WorldUtil.setHandItemWithoutAnnoyingSound((EntityPlayer)fake, EnumHand.MAIN_HAND, stack.func_77946_l());
                fake.field_71134_c.func_187251_a((EntityPlayer)fake, world, fake.func_184614_ca(), EnumHand.MAIN_HAND, offsetPos, side.func_176734_d(), 0.5f, 0.5f, 0.5f);
                ItemStack result = fake.func_184586_b(EnumHand.MAIN_HAND);
                WorldUtil.setHandItemWithoutAnnoyingSound((EntityPlayer)fake, EnumHand.MAIN_HAND, heldBefore);
                return result;
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.error("Something that places Blocks at " + offsetPos.func_177958_n() + ", " + offsetPos.func_177956_o() + ", " + offsetPos.func_177952_p() + " in World " + world.field_73011_w.getDimension() + " threw an Exception! Don't let that happen again!", (Throwable)e);
            }
        }
        return stack;
    }

    public static boolean dropItemAtSide(EnumFacing side, World world, BlockPos pos, ItemStack stack) {
        BlockPos coords = pos.func_177972_a(side);
        if (world.func_175667_e(coords)) {
            EntityItem item = new EntityItem(world, (double)coords.func_177958_n() + 0.5, (double)coords.func_177956_o() + 0.5, (double)coords.func_177952_p() + 0.5, stack);
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            return world.func_72838_d((Entity)item);
        }
        return false;
    }

    public static EnumFacing getDirectionBySidesInOrder(int side) {
        switch (side) {
            case 0: {
                return EnumFacing.UP;
            }
            case 1: {
                return EnumFacing.DOWN;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
            case 4: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.WEST;
    }

    public static EnumFacing getDirectionByPistonRotation(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
    }

    public static ArrayList<Material> getMaterialsAround(World world, BlockPos pos) {
        ArrayList<Material> blocks = new ArrayList<Material>();
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_185904_a());
        return blocks;
    }

    public static RayTraceResult getNearestPositionWithAir(World world, EntityPlayer player, int reach) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, reach, false, false, true);
    }

    private static RayTraceResult getMovingObjectPosWithReachDistance(World world, EntityPlayer player, double distance, boolean p1, boolean p2, boolean p3) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec31 = vec3.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return world.func_147447_a(vec3, vec31, p1, p2, p3);
    }

    public static RayTraceResult getNearestBlockWithDefaultReachDistance(World world, EntityPlayer player) {
        return WorldUtil.getNearestBlockWithDefaultReachDistance(world, player, false, true, false);
    }

    public static RayTraceResult getNearestBlockWithDefaultReachDistance(World world, EntityPlayer player, boolean stopOnLiquids, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e(), stopOnLiquids, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    public static void setHandItemWithoutAnnoyingSound(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)stack);
        } else if (hand == EnumHand.OFF_HAND) {
            player.field_71071_by.field_184439_c.set(0, (Object)stack);
        }
    }

    public static float fireFakeHarvestEventsForDropChance(NonNullList<ItemStack> drops, World world, BlockPos pos) {
        if (world instanceof WorldServer) {
            FakePlayer fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
            IBlockState state = world.func_180495_p(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)fake);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                return ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)fake);
            }
        }
        return 0.0f;
    }

    public static boolean breakExtraBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (player.field_71075_bZ.field_75098_d) {
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
            if (xp == -1) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, tileEntity, stack);
                block.func_180637_b(world, pos, xp);
            }
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            return true;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        if (block.removedByPlayer(state, world, pos, player, true)) {
            block.func_176206_d(world, pos, state);
        }
        stack.func_179548_a(world, state, pos, player);
        ActuallyAdditions.PROXY.sendBreakPacket(pos);
        return true;
    }
}

