/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc.apiimpl.farmer.exu;

import de.ellpeck.actuallyadditions.api.farmer.FarmerResult;
import de.ellpeck.actuallyadditions.api.farmer.IFarmerBehavior;
import de.ellpeck.actuallyadditions.api.internal.IFarmer;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ExUPlantFarmerBehavior
implements IFarmerBehavior {
    @Override
    public FarmerResult tryPlantSeed(ItemStack seed, World world, BlockPos pos, IFarmer farmer) {
        Block block;
        Item item;
        ResourceLocation reg;
        int use = 600;
        if (farmer.getEnergy() >= use && StackUtil.isValid(seed) && (reg = (item = seed.func_77973_b()).getRegistryName()) != null && this.getPlantName().equals(reg.toString()) && item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) != null) {
            BlockPos posBelow;
            IBlockState stateBelow;
            IBlockState stateThere = world.func_180495_p(pos);
            Block blockThere = stateThere.func_177230_c();
            if ((world.func_175623_d(pos) || blockThere.func_176200_f((IBlockAccess)world, pos)) && this.canPlaceOn((stateBelow = world.func_180495_p(posBelow = pos.func_177977_b())).func_177230_c())) {
                world.func_180501_a(pos, block.func_176223_P(), 2);
                farmer.extractEnergy(use);
                return FarmerResult.SUCCESS;
            }
            return FarmerResult.STOP_PROCESSING;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public FarmerResult tryHarvestPlant(World world, BlockPos pos, IFarmer farmer) {
        IBlockState state;
        Block block;
        ResourceLocation reg;
        int use = 600;
        if (farmer.getEnergy() >= use && (reg = (block = (state = world.func_180495_p(pos)).func_177230_c()).getRegistryName()) != null && this.getPlantName().equals(reg.toString())) {
            if (block.func_176201_c(state) >= this.getMaxStage()) {
                NonNullList drops = NonNullList.func_191196_a();
                block.getDrops(drops, (IBlockAccess)world, pos, state, 0);
                if (StackUtil.isEmpty((Collection<ItemStack>)drops)) {
                    return FarmerResult.FAIL;
                }
                for (ItemStack stack : drops) {
                    ResourceLocation itemReg;
                    if (!StackUtil.isValid(stack) || (itemReg = stack.func_77973_b().getRegistryName()) == null || !this.getPlantName().equals(itemReg.toString())) continue;
                    if (stack.func_190916_E() <= 1) {
                        drops.remove((Object)stack);
                        break;
                    }
                    stack.func_190918_g(1);
                }
                if (farmer.canAddToOutput((List<ItemStack>)drops)) {
                    farmer.addToOutput((List<ItemStack>)drops);
                    world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                    world.func_180501_a(pos, block.func_176223_P(), 2);
                    farmer.extractEnergy(use);
                    return FarmerResult.SUCCESS;
                }
            }
            return FarmerResult.STOP_PROCESSING;
        }
        return FarmerResult.FAIL;
    }

    @Override
    public int getPriority() {
        return 10;
    }

    protected abstract String getPlantName();

    protected abstract boolean canPlaceOn(Block var1);

    protected abstract int getMaxStage();
}

