/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EnergyDisplay
extends Gui {
    private CustomEnergyStorage rfReference;
    private int x;
    private int y;
    private boolean outline;
    private boolean drawTextNextTo;

    public EnergyDisplay(int x, int y, CustomEnergyStorage rfReference, boolean outline, boolean drawTextNextTo) {
        this.setData(x, y, rfReference, outline, drawTextNextTo);
    }

    public EnergyDisplay(int x, int y, CustomEnergyStorage rfReference) {
        this(x, y, rfReference, false, false);
    }

    public void setData(int x, int y, CustomEnergyStorage rfReference, boolean outline, boolean drawTextNextTo) {
        this.x = x;
        this.y = y;
        this.rfReference = rfReference;
        this.outline = outline;
        this.drawTextNextTo = drawTextNextTo;
    }

    public void draw() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(AssetUtil.GUI_INVENTORY_LOCATION);
        int barX = this.x;
        int barY = this.y;
        if (this.outline) {
            this.func_73729_b(this.x, this.y, 52, 163, 26, 93);
            barX += 4;
            barY += 4;
        }
        this.func_73729_b(barX, barY, 18, 171, 18, 85);
        if (this.rfReference.getEnergyStored() > 0) {
            int i = this.rfReference.getEnergyStored() * 83 / this.rfReference.getMaxEnergyStored();
            float[] color = AssetUtil.getWheelColor(mc.field_71441_e.func_82737_E() % 256L);
            GlStateManager.func_179124_c((float)(color[0] / 255.0f), (float)(color[1] / 255.0f), (float)(color[2] / 255.0f));
            this.func_73729_b(barX + 1, barY + 84 - i, 36, 172, 16, i);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (this.drawTextNextTo) {
            this.func_73731_b(mc.field_71466_p, this.getOverlayText(), barX + 25, barY + 78, 0xFFFFFF);
        }
    }

    public void drawOverlay(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Minecraft mc = Minecraft.func_71410_x();
            ArrayList<String> text = new ArrayList<String>();
            text.add(this.getOverlayText());
            GuiUtils.drawHoveringText(text, (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        }
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX < this.x + (this.outline ? 26 : 18) && mouseY < this.y + (this.outline ? 93 : 85);
    }

    private String getOverlayText() {
        NumberFormat format = NumberFormat.getInstance();
        return String.format("%s/%s Crystal Flux", format.format(this.rfReference.getEnergyStored()), format.format(this.rfReference.getMaxEnergyStored()));
    }
}

