/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen.village;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.gen.village.BasicTradeList;
import de.ellpeck.actuallyadditions.mod.gen.village.component.VillageComponentCustomCropField;
import de.ellpeck.actuallyadditions.mod.gen.village.component.VillageComponentEngineerHouse;
import de.ellpeck.actuallyadditions.mod.gen.village.component.VillageComponentJamHouse;
import de.ellpeck.actuallyadditions.mod.gen.village.component.handler.VillageCustomCropFieldHandler;
import de.ellpeck.actuallyadditions.mod.gen.village.component.handler.VillageEngineerHouseHandler;
import de.ellpeck.actuallyadditions.mod.gen.village.component.handler.VillageJamHouseHandler;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheCrystals;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheJams;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public final class InitVillager {
    public static VillagerRegistry.VillagerProfession jamProfession;
    public static VillagerRegistry.VillagerProfession engineerProfession;

    public static void init() {
        ActuallyAdditions.LOGGER.info("Initializing Village Addons...");
        if (ConfigBoolValues.JAM_VILLAGER_EXISTS.isEnabled()) {
            InitVillager.initJamVillagePart();
        }
        if (ConfigBoolValues.CROP_FIELD_EXISTS.isEnabled()) {
            InitVillager.initCustomCropFieldPart();
        }
        if (ConfigBoolValues.ENGINEER_VILLAGER_EXISTS.isEnabled()) {
            InitVillager.initEngineerVillagePart();
        }
    }

    private static void initEngineerVillagePart() {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageEngineerHouseHandler());
        MapGenStructureIO.func_143031_a(VillageComponentEngineerHouse.class, (String)"actuallyadditions:engineerHouseStructure");
        engineerProfession = new VillagerRegistry.VillagerProfession("actuallyadditions:engineer", "actuallyadditions:textures/entity/villager/engineer_villager.png", "actuallyadditions:textures/entity/villager/engineer_villager_zombie.png");
        VillagerRegistry.VillagerCareer crystallizer = new VillagerRegistry.VillagerCareer(engineerProfession, "actuallyadditions.crystallizer");
        crystallizer.addTrade(1, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(1, 2), new ItemStack(InitItems.itemCrystal, 1, TheCrystals.COAL.ordinal()), new EntityVillager.PriceInfo(2, 8)), new BasicTradeList(new EntityVillager.PriceInfo(1, 3), new ItemStack(InitItems.itemCrystal, 1, TheCrystals.IRON.ordinal()), new EntityVillager.PriceInfo(2, 6)), new BasicTradeList(new EntityVillager.PriceInfo(1, 3), new ItemStack(InitItems.itemCrystal, 1, TheCrystals.REDSTONE.ordinal()), new EntityVillager.PriceInfo(1, 4)), new BasicTradeList(new ItemStack(InitItems.itemCrystal, 1, TheCrystals.COAL.ordinal()), new EntityVillager.PriceInfo(10, 16), new EntityVillager.PriceInfo(1, 1))});
        crystallizer.addTrade(2, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(2, 3), new ItemStack(InitItems.itemCrystal, 1, TheCrystals.EMERALD.ordinal()), new EntityVillager.PriceInfo(2, 4)), new BasicTradeList(new EntityVillager.PriceInfo(1, 3), new ItemStack(InitItems.itemCrystal, 1, TheCrystals.LAPIS.ordinal()), new EntityVillager.PriceInfo(2, 6)), new BasicTradeList(new ItemStack(InitItems.itemCrystal, 1, TheCrystals.IRON.ordinal()), new EntityVillager.PriceInfo(8, 12), new EntityVillager.PriceInfo(1, 1)), new BasicTradeList(new ItemStack(InitItems.itemCrystal, 1, TheCrystals.REDSTONE.ordinal()), new EntityVillager.PriceInfo(8, 16), new EntityVillager.PriceInfo(1, 2))});
        crystallizer.addTrade(3, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(2, 4), new ItemStack(InitItems.itemCrystal, 1, TheCrystals.DIAMOND.ordinal()), new EntityVillager.PriceInfo(2, 3)), new BasicTradeList(new ItemStack(InitItems.itemCrystal, 1, TheCrystals.LAPIS.ordinal()), new EntityVillager.PriceInfo(6, 10), new EntityVillager.PriceInfo(1, 1)), new BasicTradeList(new ItemStack(InitItems.itemCrystal, 1, TheCrystals.DIAMOND.ordinal()), new EntityVillager.PriceInfo(4, 6), new EntityVillager.PriceInfo(1, 1)), new BasicTradeList(new ItemStack(InitItems.itemCrystal, 1, TheCrystals.EMERALD.ordinal()), new EntityVillager.PriceInfo(6, 12), new EntityVillager.PriceInfo(1, 2))});
        VillagerRegistry.VillagerCareer engineer = new VillagerRegistry.VillagerCareer(engineerProfession, "actuallyadditions.engineer");
        engineer.addTrade(1, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(1, 2), new ItemStack(InitBlocks.blockMisc, 1, TheMiscBlocks.ORE_QUARTZ.ordinal()), new EntityVillager.PriceInfo(2, 3)), new BasicTradeList(new EntityVillager.PriceInfo(1, 2), new ItemStack(InitItems.itemMisc, 1, TheMiscItems.QUARTZ.ordinal()), new EntityVillager.PriceInfo(6, 8)), new BasicTradeList(new EntityVillager.PriceInfo(1, 3), new ItemStack(InitItems.itemLaserWrench), new EntityVillager.PriceInfo(1, 1))});
        engineer.addTrade(2, new EntityVillager.ITradeList[]{new BasicTradeList(new ItemStack(InitItems.itemCoffeeBean), new EntityVillager.PriceInfo(20, 30), new EntityVillager.PriceInfo(1, 2)), new BasicTradeList(new EntityVillager.PriceInfo(3, 5), new ItemStack(InitItems.itemPhantomConnector), new EntityVillager.PriceInfo(1, 1)), new BasicTradeList(new EntityVillager.PriceInfo(10, 20), new ItemStack(InitBlocks.blockLaserRelay), new EntityVillager.PriceInfo(1, 2))});
        engineer.addTrade(3, new EntityVillager.ITradeList[]{new BasicTradeList(new ItemStack(InitBlocks.blockTinyTorch), new EntityVillager.PriceInfo(30, 40), new EntityVillager.PriceInfo(1, 2)), new BasicTradeList(new EntityVillager.PriceInfo(1, 2), new ItemStack(InitBlocks.blockMisc, 1, TheMiscBlocks.WOOD_CASING.ordinal()), new EntityVillager.PriceInfo(1, 2))});
        engineer.addTrade(4, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(3, 5), new ItemStack(InitBlocks.blockMisc, 1, TheMiscBlocks.IRON_CASING.ordinal()), new EntityVillager.PriceInfo(1, 2)), new BasicTradeList(new ItemStack(InitBlocks.blockEmpowerer), new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(15, 20)), new BasicTradeList(new EntityVillager.PriceInfo(30, 40), new ItemStack(InitBlocks.blockLaserRelayExtreme), new EntityVillager.PriceInfo(1, 1))});
    }

    private static void initJamVillagePart() {
        jamProfession = new VillagerRegistry.VillagerProfession("actuallyadditions:jamGuy", "actuallyadditions:textures/entity/villager/jam_villager.png", "actuallyadditions:textures/entity/villager/jam_villager_zombie.png");
        VillagerRegistry.VillagerCareer career = new VillagerRegistry.VillagerCareer(jamProfession, "actuallyadditions.jammer");
        career.addTrade(1, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(1, 4), new ItemStack(InitItems.itemJams, 1, TheJams.CU_BA_RA.ordinal()), new EntityVillager.PriceInfo(1, 3)), new BasicTradeList(new EntityVillager.PriceInfo(1, 4), new ItemStack(InitItems.itemJams, 1, TheJams.GRA_KI_BA.ordinal()), new EntityVillager.PriceInfo(1, 3))});
        career.addTrade(2, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(1, 4), new ItemStack(InitItems.itemJams, 1, TheJams.PL_AP_LE.ordinal()), new EntityVillager.PriceInfo(1, 3)), new BasicTradeList(new EntityVillager.PriceInfo(1, 4), new ItemStack(InitItems.itemJams, 1, TheJams.CH_AP_CI.ordinal()), new EntityVillager.PriceInfo(1, 3)), new BasicTradeList(new EntityVillager.PriceInfo(1, 4), new ItemStack(InitItems.itemJams, 1, TheJams.HO_ME_KI.ordinal()), new EntityVillager.PriceInfo(1, 3))});
        career.addTrade(3, new EntityVillager.ITradeList[]{new BasicTradeList(new EntityVillager.PriceInfo(1, 4), new ItemStack(InitItems.itemJams, 1, TheJams.HO_ME_CO.ordinal()), new EntityVillager.PriceInfo(1, 3)), new BasicTradeList(new EntityVillager.PriceInfo(1, 4), new ItemStack(InitItems.itemJams, 1, TheJams.PI_CO.ordinal()), new EntityVillager.PriceInfo(1, 3))});
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageJamHouseHandler());
        MapGenStructureIO.func_143031_a(VillageComponentJamHouse.class, (String)"actuallyadditions:jamHouseStructure");
    }

    private static void initCustomCropFieldPart() {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageCustomCropFieldHandler());
        MapGenStructureIO.func_143031_a(VillageComponentCustomCropField.class, (String)"actuallyadditions:customCropFieldStructure");
    }
}

