/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityShockSuppressor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockShockSuppressor
extends BlockContainerBase {
    public BlockShockSuppressor(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(20.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185851_d);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            List affectedBlocks = event.getAffectedBlocks();
            List affectedEntities = event.getAffectedEntities();
            int rangeSq = 25;
            int use = 300;
            block0: for (TileEntityShockSuppressor suppressor : TileEntityShockSuppressor.SUPPRESSORS) {
                if (suppressor.isRedstonePowered) continue;
                BlockPos supPos = suppressor.func_174877_v();
                ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
                ArrayList<BlockPos> posesToRemove = new ArrayList<BlockPos>();
                for (BlockPos pos : affectedBlocks) {
                    if (!(pos.func_177951_i((Vec3i)supPos) <= (double)rangeSq)) continue;
                    posesToRemove.add(pos);
                }
                for (Entity entity : affectedEntities) {
                    if (!(entity.func_174791_d().func_186679_c((double)supPos.func_177958_n(), (double)supPos.func_177956_o(), (double)supPos.func_177952_p()) <= (double)rangeSq)) continue;
                    entitiesToRemove.add(entity);
                }
                Collections.shuffle(entitiesToRemove);
                Collections.shuffle(posesToRemove);
                for (BlockPos pos : posesToRemove) {
                    if (suppressor.storage.getEnergyStored() < use) break;
                    suppressor.storage.extractEnergyInternal(use, false);
                    affectedBlocks.remove(pos);
                }
                for (Entity entity : entitiesToRemove) {
                    if (suppressor.storage.getEnergyStored() < use) continue block0;
                    suppressor.storage.extractEnergyInternal(use, false);
                    affectedEntities.remove(entity);
                }
            }
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityShockSuppressor();
    }
}

