/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import pl.asie.charset.api.lib.ISimpleInstantiatingRegistry;

public class CharsetSimpleInstantiatingRegistry<T>
implements ISimpleInstantiatingRegistry<T> {
    public final List<Supplier<T>> LIST = new ArrayList<Supplier<T>>();
    public final TObjectIntMap<Class<? extends T>> MAP = new TObjectIntHashMap();

    @Override
    public boolean register(Class<? extends T> clazz, Supplier<T> supplier) {
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Tried to register class with no empty constructor %s!", clazz.getName()));
        }
        this.MAP.put(clazz, this.LIST.size());
        return this.LIST.add(supplier);
    }

    @Override
    public int getId(T object) {
        return this.MAP.get(object.getClass());
    }

    @Override
    public Supplier<T> get(int id) {
        if (id < 0 || this.LIST.size() <= id) {
            throw new IllegalStateException(String.format("Tried to access unregistered ID %d!", id));
        }
        return this.LIST.get(id);
    }

    @Override
    public T create(int id) {
        try {
            return this.get(id).get();
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

