/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.modcompat.mcmultipart;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.MultipartHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IRedstoneEmitter;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.modcompat.mcmultipart.MCMPUtils;
import pl.asie.charset.lib.utils.redstone.IRedstoneGetter;

public class RedstoneGetterMultipart
implements IRedstoneGetter {
    @Override
    public int get(IBlockAccess world, BlockPos pos, EnumFacing face, @Nullable EnumFacing edge, Predicate<TileEntity> tileEntityPredicate) {
        Optional container = MultipartHelper.getContainer((IBlockAccess)world, (BlockPos)pos);
        if (container.isPresent()) {
            return MCMPUtils.streamParts((IMultipartContainer)container.get(), edge, face.func_176734_d()).map(info -> {
                if (info.getTile() != null && info.getTile().getTileEntity() != null && !tileEntityPredicate.test(info.getTile().getTileEntity())) {
                    return 0;
                }
                if (info.getTile().hasPartCapability(Capabilities.REDSTONE_EMITTER, face.func_176734_d())) {
                    return ((IRedstoneEmitter)info.getTile().getPartCapability(Capabilities.REDSTONE_EMITTER, face.func_176734_d())).getRedstoneSignal();
                }
                if (info.getState().func_185897_m()) {
                    return info.getPart().getWeakPower((IBlockAccess)info.getPartWorld(), info.getPartPos(), info, face);
                }
                return -1;
            }).filter(a -> a >= 0).findFirst().orElse(0);
        }
        return -1;
    }

    @Override
    public byte[] getBundled(IBlockAccess world, BlockPos pos, EnumFacing face, @Nullable EnumFacing edge, Predicate<TileEntity> tileEntityPredicate) {
        Optional container = MultipartHelper.getContainer((IBlockAccess)world, (BlockPos)pos);
        if (container.isPresent()) {
            return MCMPUtils.streamParts((IMultipartContainer)container.get(), edge, face.func_176734_d()).map(info -> {
                if (info.getTile() != null && info.getTile().getTileEntity() != null && !tileEntityPredicate.test(info.getTile().getTileEntity())) {
                    return new byte[16];
                }
                if (info.getTile().hasPartCapability(Capabilities.BUNDLED_EMITTER, face.func_176734_d())) {
                    return ((IBundledEmitter)info.getTile().getPartCapability(Capabilities.BUNDLED_EMITTER, face.func_176734_d())).getBundledSignal();
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(new byte[16]);
        }
        return null;
    }
}

