/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.modcompat.jei;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.loader.AnnotatedPluginHandler;
import pl.asie.charset.lib.modcompat.jei.CharsetJEIPlugin;
import pl.asie.charset.lib.modcompat.jei.JEIRecipeContainer;
import pl.asie.charset.lib.modcompat.jei.JEIRecipeDyeableItem;
import pl.asie.charset.lib.recipe.DyeableItemRecipeFactory;
import pl.asie.charset.lib.recipe.InventoryCraftingIterator;
import pl.asie.charset.lib.recipe.RecipeCharset;

@JEIPlugin
public class JEIPluginCharset
extends AnnotatedPluginHandler<IModPlugin>
implements IModPlugin {
    public static IStackHelper STACKS;
    public static IIngredientRegistry INGREDIENT_REGISTRY;
    public static IRecipeTransferHandlerHelper RECIPE_TRANSFER_HANDLERS;
    public static IGuiHelper GUIS;

    public JEIPluginCharset() {
        super(CharsetJEIPlugin.class);
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        for (IModPlugin plugin : this.getPlugins()) {
            plugin.registerItemSubtypes(subtypeRegistry);
        }
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        for (IModPlugin plugin : this.getPlugins()) {
            plugin.registerIngredients(registry);
        }
    }

    public void register(@Nonnull IModRegistry registry) {
        STACKS = registry.getJeiHelpers().getStackHelper();
        GUIS = registry.getJeiHelpers().getGuiHelper();
        RECIPE_TRANSFER_HANDLERS = registry.getJeiHelpers().recipeTransferHandlerHelper();
        INGREDIENT_REGISTRY = registry.getIngredientRegistry();
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!(recipe instanceof RecipeCharset)) continue;
            InventoryCraftingIterator iterator = new InventoryCraftingIterator((RecipeCharset)recipe, false);
            while (iterator.hasNext()) {
                iterator.next();
                if (!recipe.func_77569_a((InventoryCrafting)iterator, null)) continue;
                InventoryCraftingIterator.Container ctr = iterator.contain();
                registry.addRecipes(Collections.singletonList(ctr), "minecraft.crafting");
            }
        }
        registry.handleRecipes(InventoryCraftingIterator.Container.class, JEIRecipeContainer::create, "minecraft.crafting");
        registry.handleRecipes(DyeableItemRecipeFactory.Recipe.class, JEIRecipeDyeableItem::create, "minecraft.crafting");
        for (IModPlugin plugin : this.getPlugins()) {
            plugin.register(registry);
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        if (CharsetLib.showAllItemTypesJEI && !CharsetLib.showAllItemTypes) {
            for (Item item : ForgeRegistries.ITEMS) {
                ISubItemProvider provider;
                if (!(item instanceof ISubItemProvider.Container) || (provider = ((ISubItemProvider.Container)item).getSubItemProvider()) == null) continue;
                List<ItemStack> cBase = provider.getItems();
                List<ItemStack> c = provider.getAllItems();
                if (c.isEmpty() || c.size() <= cBase.size()) continue;
                INGREDIENT_REGISTRY.addIngredientsAtRuntime(ItemStack.class, c);
            }
        }
        for (IModPlugin plugin : this.getPlugins()) {
            plugin.onRuntimeAvailable(jeiRuntime);
        }
    }
}

