/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.loader;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import pl.asie.charset.lib.loader.ModuleLoader;

public abstract class AnnotatedPluginHandler<T> {
    private final Class annotationClass;
    private Set<T> plugins = null;

    protected AnnotatedPluginHandler(Class annotationClass) {
        this.annotationClass = annotationClass;
    }

    public Set<T> getPlugins() {
        if (this.plugins == null) {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (String s : ModuleLoader.classNames.get((Object)this.annotationClass)) {
                try {
                    Object plugin = Class.forName(s).newInstance();
                    builder.add(plugin);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.plugins = builder.build();
        }
        return this.plugins;
    }
}

