/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcmultipart.api.multipart.MultipartCapabilityHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.audio.IAudioSource;
import pl.asie.charset.api.carry.CustomCarryHandler;
import pl.asie.charset.api.experimental.mechanical.IMechanicalPowerConsumer;
import pl.asie.charset.api.experimental.mechanical.IMechanicalPowerProducer;
import pl.asie.charset.api.laser.ILaserReceiver;
import pl.asie.charset.api.lib.IAxisRotatable;
import pl.asie.charset.api.lib.IDebuggable;
import pl.asie.charset.api.lib.IDyeableItem;
import pl.asie.charset.api.lib.IItemInsertionHandler;
import pl.asie.charset.api.lib.IMovable;
import pl.asie.charset.api.lib.IMultiblockStructure;
import pl.asie.charset.api.locks.Lockable;
import pl.asie.charset.api.pipes.IPipeView;
import pl.asie.charset.api.storage.IBarrel;
import pl.asie.charset.api.tools.IStopwatchTracker;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.IRedstoneEmitter;
import pl.asie.charset.api.wires.IRedstoneReceiver;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.lib.capability.DummyCapabilityStorage;
import pl.asie.charset.lib.capability.audio.AudioReceiverCombiner;
import pl.asie.charset.lib.capability.audio.DefaultAudioReceiver;
import pl.asie.charset.lib.capability.audio.DefaultAudioSource;
import pl.asie.charset.lib.capability.impl.CustomCarryHandlerCactus;
import pl.asie.charset.lib.capability.impl.CustomCarryHandlerChest;
import pl.asie.charset.lib.capability.impl.CustomCarryHandlerMobSpawner;
import pl.asie.charset.lib.capability.impl.MultiblockStructureBed;
import pl.asie.charset.lib.capability.impl.MultiblockStructureChest;
import pl.asie.charset.lib.capability.impl.MultiblockStructureDoor;
import pl.asie.charset.lib.capability.inventory.DefaultItemInsertionHandler;
import pl.asie.charset.lib.capability.inventory.ItemInsertionHandlerCombiner;
import pl.asie.charset.lib.capability.laser.DummyLaserReceiver;
import pl.asie.charset.lib.capability.laser.LaserReceiverCombiner;
import pl.asie.charset.lib.capability.lib.AxisRotatableCombiner;
import pl.asie.charset.lib.capability.lib.DebuggableCombiner;
import pl.asie.charset.lib.capability.lib.DefaultAxisRotatable;
import pl.asie.charset.lib.capability.lib.DefaultDebuggable;
import pl.asie.charset.lib.capability.lib.DefaultMovable;
import pl.asie.charset.lib.capability.lib.DefaultMultiblockStructure;
import pl.asie.charset.lib.capability.lib.DyeableItem;
import pl.asie.charset.lib.capability.lib.DyeableItemStorage;
import pl.asie.charset.lib.capability.mechanical.DefaultMechanicalPowerConsumer;
import pl.asie.charset.lib.capability.mechanical.DefaultMechanicalPowerProducer;
import pl.asie.charset.lib.capability.pipe.DefaultPipeView;
import pl.asie.charset.lib.capability.redstone.BundledEmitterCombiner;
import pl.asie.charset.lib.capability.redstone.BundledReceiverCombiner;
import pl.asie.charset.lib.capability.redstone.DefaultBundledEmitter;
import pl.asie.charset.lib.capability.redstone.DefaultBundledEmitterStorage;
import pl.asie.charset.lib.capability.redstone.DefaultRedstoneEmitter;
import pl.asie.charset.lib.capability.redstone.DefaultRedstoneEmitterStorage;
import pl.asie.charset.lib.capability.redstone.DummyRedstoneReceiver;
import pl.asie.charset.lib.capability.redstone.RedstoneEmitterCombiner;
import pl.asie.charset.lib.capability.redstone.RedstoneReceiverCombiner;
import pl.asie.charset.lib.capability.staging.DefaultConfigurationHolder;
import pl.asie.charset.lib.capability.staging.DefaultSignalMeterDataProvider;
import pl.asie.charset.lib.capability.storage.DummyBarrel;
import pl.asie.charset.lib.capability.tools.DefaultStopwatchTracker;
import pl.asie.charset.lib.capability.wrappers.CapabilityWrapperFluidStacks;
import pl.asie.charset.lib.capability.wrappers.CapabilityWrapperInsertionToItemHandler;
import pl.asie.charset.lib.capability.wrappers.CapabilityWrapperInventory;
import pl.asie.charset.lib.stagingapi.IConfigurationHolder;
import pl.asie.charset.lib.stagingapi.ISignalMeterDataProvider;

public class Capabilities {
    @CapabilityInject(value=IAudioSource.class)
    public static Capability<IAudioSource> AUDIO_SOURCE;
    @CapabilityInject(value=IAudioReceiver.class)
    public static Capability<IAudioReceiver> AUDIO_RECEIVER;
    @CapabilityInject(value=IAxisRotatable.class)
    public static Capability<IAxisRotatable> AXIS_ROTATABLE;
    @CapabilityInject(value=IDebuggable.class)
    public static Capability<IDebuggable> DEBUGGABLE;
    @CapabilityInject(value=IMovable.class)
    public static Capability<IMovable> MOVABLE;
    @CapabilityInject(value=IDyeableItem.class)
    public static Capability<IDyeableItem> DYEABLE_ITEM;
    @CapabilityInject(value=IItemInsertionHandler.class)
    public static Capability<IItemInsertionHandler> ITEM_INSERTION_HANDLER;
    @CapabilityInject(value=IPipeView.class)
    public static Capability<IPipeView> PIPE_VIEW;
    @CapabilityInject(value=IMechanicalPowerProducer.class)
    public static Capability<IMechanicalPowerProducer> MECHANICAL_PRODUCER;
    @CapabilityInject(value=IMechanicalPowerConsumer.class)
    public static Capability<IMechanicalPowerConsumer> MECHANICAL_CONSUMER;
    @CapabilityInject(value=IBundledEmitter.class)
    public static Capability<IBundledEmitter> BUNDLED_EMITTER;
    @CapabilityInject(value=IBundledReceiver.class)
    public static Capability<IBundledReceiver> BUNDLED_RECEIVER;
    @CapabilityInject(value=IRedstoneEmitter.class)
    public static Capability<IRedstoneEmitter> REDSTONE_EMITTER;
    @CapabilityInject(value=IRedstoneReceiver.class)
    public static Capability<IRedstoneReceiver> REDSTONE_RECEIVER;
    @CapabilityInject(value=IConfigurationHolder.class)
    public static Capability<IConfigurationHolder> CONFIGURATION_HOLDER;
    @CapabilityInject(value=ISignalMeterDataProvider.class)
    public static Capability<ISignalMeterDataProvider> SIGNAL_METER_DATA_PROVIDER;
    @CapabilityInject(value=IBarrel.class)
    public static Capability<IBarrel> BARREL;
    @CapabilityInject(value=Lockable.class)
    public static Capability<Lockable> LOCKABLE;
    @CapabilityInject(value=IStopwatchTracker.class)
    public static Capability<IStopwatchTracker> STOPWATCH_TRACKER;
    @CapabilityInject(value=IMultiblockStructure.class)
    public static Capability<IMultiblockStructure> MULTIBLOCK_STRUCTURE;
    @CapabilityInject(value=CustomCarryHandler.Provider.class)
    public static Capability<CustomCarryHandler.Provider> CUSTOM_CARRY_PROVIDER;
    @CapabilityInject(value=ILaserReceiver.class)
    public static Capability<ILaserReceiver> LASER_RECEIVER;
    public static Capability.IStorage<Lockable> LOCKABLE_STORAGE;
    private static final ResourceLocation MULTIBLOCK_STRUCTURE_LOC;
    private static CapabilityProviderFactory<IMultiblockStructure> multiblockStructureFactory;

    public static void preInit() {
        CapabilityManager.INSTANCE.register(IAudioSource.class, DummyCapabilityStorage.get(), DefaultAudioSource::new);
        CapabilityManager.INSTANCE.register(IAudioReceiver.class, DummyCapabilityStorage.get(), DefaultAudioReceiver::new);
        CapabilityManager.INSTANCE.register(IAxisRotatable.class, DummyCapabilityStorage.get(), DefaultAxisRotatable::new);
        CapabilityManager.INSTANCE.register(IDebuggable.class, DummyCapabilityStorage.get(), DefaultDebuggable::new);
        CapabilityManager.INSTANCE.register(IMovable.class, DummyCapabilityStorage.get(), DefaultMovable::new);
        CapabilityManager.INSTANCE.register(IDyeableItem.class, (Capability.IStorage)new DyeableItemStorage(), DyeableItem::new);
        CapabilityManager.INSTANCE.register(IItemInsertionHandler.class, DummyCapabilityStorage.get(), DefaultItemInsertionHandler::new);
        CapabilityManager.INSTANCE.register(IPipeView.class, DummyCapabilityStorage.get(), DefaultPipeView::new);
        CapabilityManager.INSTANCE.register(IMechanicalPowerProducer.class, DummyCapabilityStorage.get(), DefaultMechanicalPowerProducer::new);
        CapabilityManager.INSTANCE.register(IMechanicalPowerConsumer.class, DummyCapabilityStorage.get(), DefaultMechanicalPowerConsumer::new);
        CapabilityManager.INSTANCE.register(IBundledEmitter.class, (Capability.IStorage)new DefaultBundledEmitterStorage(), DefaultBundledEmitter::new);
        CapabilityManager.INSTANCE.register(IRedstoneEmitter.class, (Capability.IStorage)new DefaultRedstoneEmitterStorage(), DefaultRedstoneEmitter::new);
        CapabilityManager.INSTANCE.register(IBundledReceiver.class, DummyCapabilityStorage.get(), DummyRedstoneReceiver::new);
        CapabilityManager.INSTANCE.register(IRedstoneReceiver.class, DummyCapabilityStorage.get(), DummyRedstoneReceiver::new);
        CapabilityManager.INSTANCE.register(IConfigurationHolder.class, DummyCapabilityStorage.get(), DefaultConfigurationHolder::new);
        CapabilityManager.INSTANCE.register(ISignalMeterDataProvider.class, DummyCapabilityStorage.get(), DefaultSignalMeterDataProvider::new);
        CapabilityManager.INSTANCE.register(IBarrel.class, DummyCapabilityStorage.get(), DummyBarrel::new);
        CapabilityManager.INSTANCE.register(Lockable.class, LOCKABLE_STORAGE, Lockable::new);
        CapabilityManager.INSTANCE.register(IMultiblockStructure.class, DummyCapabilityStorage.get(), DefaultMultiblockStructure::new);
        CapabilityManager.INSTANCE.register(IStopwatchTracker.class, DummyCapabilityStorage.get(), DefaultStopwatchTracker::new);
        CapabilityManager.INSTANCE.register(ILaserReceiver.class, DummyCapabilityStorage.get(), DummyLaserReceiver::new);
        CapabilityManager.INSTANCE.register(CustomCarryHandler.Provider.class, DummyCapabilityStorage.get(), () -> handler -> new CustomCarryHandler(handler));
        MinecraftForge.EVENT_BUS.register((Object)new Capabilities());
        multiblockStructureFactory = new CapabilityProviderFactory<IMultiblockStructure>(MULTIBLOCK_STRUCTURE, DummyCapabilityStorage.get());
    }

    public static void init() {
        if (Loader.isModLoaded((String)"mcmultipart")) {
            Capabilities.initMultiplePants();
        }
        CapabilityHelper.registerBlockProvider(CUSTOM_CARRY_PROVIDER, Blocks.field_150474_ac, (a, b, c, d) -> CustomCarryHandlerMobSpawner::new);
        for (Block block : Block.field_149771_c) {
            if (block instanceof BlockDoor && block.func_176194_O().func_177623_d().contains(BlockDoor.field_176523_O)) {
                CapabilityHelper.registerBlockProvider(MULTIBLOCK_STRUCTURE, block, MultiblockStructureDoor::new);
            }
            if (block instanceof BlockCactus) {
                CapabilityHelper.registerBlockProvider(CUSTOM_CARRY_PROVIDER, block, (a, b, c, d) -> CustomCarryHandlerCactus::new);
            }
            if (!(block instanceof BlockChest)) continue;
            CapabilityHelper.registerBlockProvider(CUSTOM_CARRY_PROVIDER, block, (a, b, c, d) -> CustomCarryHandlerChest::new);
        }
    }

    @Optional.Method(modid="mcmultipart")
    private static void initMultiplePants() {
        MultipartCapabilityHelper.registerCapabilityJoiner(AUDIO_RECEIVER, (Function)new AudioReceiverCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(BUNDLED_EMITTER, (Function)new BundledEmitterCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(REDSTONE_EMITTER, (Function)new RedstoneEmitterCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(BUNDLED_RECEIVER, (Function)new BundledReceiverCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(REDSTONE_RECEIVER, (Function)new RedstoneReceiverCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(AXIS_ROTATABLE, (Function)new AxisRotatableCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(DEBUGGABLE, (Function)new DebuggableCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(ITEM_INSERTION_HANDLER, (Function)new ItemInsertionHandlerCombiner());
        MultipartCapabilityHelper.registerCapabilityJoiner(LASER_RECEIVER, (Function)new LaserReceiverCombiner());
    }

    public static void registerVanillaWrappers() {
        CapabilityHelper.registerWrapper(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, new CapabilityWrapperInventory());
        CapabilityHelper.registerWrapper(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, new CapabilityWrapperFluidStacks());
        CapabilityHelper.registerWrapper(ITEM_INSERTION_HANDLER, new CapabilityWrapperInsertionToItemHandler());
    }

    @SubscribeEvent
    public void onAttachCapabilityTile(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityChest) {
            event.addCapability(MULTIBLOCK_STRUCTURE_LOC, multiblockStructureFactory.create(new MultiblockStructureChest((TileEntityChest)event.getObject())));
        } else if (event.getObject() instanceof TileEntityBed) {
            event.addCapability(MULTIBLOCK_STRUCTURE_LOC, multiblockStructureFactory.create(new MultiblockStructureBed((TileEntityBed)event.getObject())));
        }
    }

    static {
        LOCKABLE_STORAGE = new Capability.IStorage<Lockable>(){

            @Nullable
            public NBTBase writeNBT(Capability<Lockable> capability, Lockable instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<Lockable> capability, Lockable instance, EnumFacing side, NBTBase nbt) {
                if (nbt instanceof NBTTagCompound) {
                    instance.deserializeNBT((NBTTagCompound)nbt);
                }
            }
        };
        MULTIBLOCK_STRUCTURE_LOC = new ResourceLocation("charset:multiblock_structure");
    }
}

