/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.block;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.lib.block.ITraitItemAppendable;
import pl.asie.charset.lib.block.Trait;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.utils.ItemUtils;

public class TraitMaterial
extends Trait
implements ITraitItemAppendable {
    private final String name;
    private final ItemMaterial defaultMaterial;
    private ItemMaterial material;

    public TraitMaterial(String name, ItemMaterial material) {
        this.name = name;
        this.defaultMaterial = material;
        this.material = material;
    }

    public ItemMaterial getMaterial() {
        return this.material;
    }

    @Override
    public ItemStack saveToStack(ItemStack stack) {
        this.material.writeToNBT(ItemUtils.getTagCompound(stack, true), this.name);
        return stack;
    }

    @Override
    public void loadFromStack(ItemStack stack) {
        if (stack.func_77942_o()) {
            ItemMaterial newMaterial = ItemMaterialRegistry.INSTANCE.getMaterial(stack.func_77978_p(), this.name);
            this.material = newMaterial != null ? newMaterial : this.defaultMaterial;
        }
    }

    @Override
    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        ItemMaterial newMaterial = ItemMaterialRegistry.INSTANCE.getMaterial(compound, "material");
        this.material = newMaterial != null ? newMaterial : this.defaultMaterial;
    }

    @Override
    public NBTTagCompound writeNBTData(boolean isClient) {
        NBTTagCompound tag = new NBTTagCompound();
        this.material.writeToNBT(tag, "material");
        return tag;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return null;
    }
}

