/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.CharsetAPI;
import pl.asie.charset.api.audio.AudioAPI;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioSink;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.CharsetLibEventHandler;
import pl.asie.charset.lib.CharsetSounds;
import pl.asie.charset.lib.audio.PacketAudioData;
import pl.asie.charset.lib.audio.PacketAudioStop;
import pl.asie.charset.lib.audio.manager.AudioStreamManager;
import pl.asie.charset.lib.audio.types.AudioDataDFPWM;
import pl.asie.charset.lib.audio.types.AudioDataGameSound;
import pl.asie.charset.lib.audio.types.AudioSinkBlock;
import pl.asie.charset.lib.block.PacketCustomBlockDust;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.command.CommandCharset;
import pl.asie.charset.lib.command.SubCommandAt;
import pl.asie.charset.lib.command.SubCommandClientCmdList;
import pl.asie.charset.lib.command.SubCommandFog;
import pl.asie.charset.lib.command.SubCommandHand;
import pl.asie.charset.lib.command.SubCommandHelp;
import pl.asie.charset.lib.command.SubCommandSetupTestWorld;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.handlers.DebugInfoProvider;
import pl.asie.charset.lib.handlers.DyeableItemWashHandler;
import pl.asie.charset.lib.handlers.FluidExtraInformationHandler;
import pl.asie.charset.lib.handlers.PacketRequestScroll;
import pl.asie.charset.lib.handlers.PlayerDeathHandler;
import pl.asie.charset.lib.handlers.ShiftScrollHandler;
import pl.asie.charset.lib.handlers.SplashTextHandler;
import pl.asie.charset.lib.item.SubItemProviderCache;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.material.ColorLookupHandler;
import pl.asie.charset.lib.material.FastRecipeLookup;
import pl.asie.charset.lib.material.ItemMaterialHeuristics;
import pl.asie.charset.lib.misc.Todokete;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.notify.NotifyImplementation;
import pl.asie.charset.lib.notify.PacketNotification;
import pl.asie.charset.lib.notify.PacketPoint;
import pl.asie.charset.lib.recipe.IngredientGroup;
import pl.asie.charset.lib.recipe.RecipeIngredientPatcher;
import pl.asie.charset.lib.recipe.RecipeReplacement;
import pl.asie.charset.lib.render.model.ModelFactory;
import pl.asie.charset.lib.render.sprite.TextureWhitener;
import pl.asie.charset.lib.resources.CharsetFakeResourcePack;
import pl.asie.charset.lib.resources.ColorPaletteParser;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.lib.utils.CharsetSimpleInstantiatingRegistry;
import pl.asie.charset.lib.utils.DataSerializersCharset;
import pl.asie.charset.lib.utils.UtilProxyCommon;
import pl.asie.charset.lib.utils.colorspace.Colorspaces;

@CharsetModule(name="lib", description="Library module", profile=ModuleProfile.STABLE, isVisible=false)
public class CharsetLib {
    @CharsetModule.Instance
    public static CharsetLib instance;
    @CharsetModule.PacketRegistry
    public static PacketRegistry packet;
    @CharsetModule.Configuration
    public static Configuration config;
    public static Supplier<Calendar> calendar;
    public static PlayerDeathHandler deathHandler;
    public static boolean alwaysDropDroppablesGivenToPlayer;
    public static boolean enableDebugInfo;
    public static boolean showAllItemTypes;
    public static boolean showAllItemTypesJEI;
    public static boolean showHandClasses;
    public static int doubleClickDuration;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        ModelFactory.clearCaches();
        TextureWhitener.INSTANCE.clear();
        ColorLookupHandler.INSTANCE.clear();
        CharsetFakeResourcePack.INSTANCE.invalidate();
        CharsetFakeResourcePack.INSTANCE.clearTexturesFromManager();
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        try {
            Field field = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"defaultResourcePacks", "field_110449_ao"});
            ((List)field.get(Minecraft.func_71410_x())).add(CharsetFakeResourcePack.INSTANCE);
            IReloadableResourceManager rrm = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
            rrm.func_110542_a((IResourceManagerReloadListener)CharsetFakeResourcePack.INSTANCE);
            Minecraft.func_71410_x().func_110436_a();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.register((Object)ColorPaletteParser.INSTANCE);
    }

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        alwaysDropDroppablesGivenToPlayer = ConfigUtils.getBoolean(config, "general", "alwaysDropDroppablesGivenToPlayer", false, "Setting this option to true will stop Charset from giving players items directly into the player inventory when the alternative is dropping it (for instance, taking item out of barrels).", true);
        enableDebugInfo = ConfigUtils.getBoolean(config, "expert", "enableDebugInfo", ModCharset.INDEV, "Enable developer debugging information. Don't enable this unless asked/you know what you're doing.", false);
        showHandClasses = ConfigUtils.getBoolean(config, "expert", "commandsShowClasses", true, "Enable the '/ch hand class' and '/ch at class' commands.", false);
        FastRecipeLookup.ENABLED = !ConfigUtils.getBoolean(config, "general", "disableRecipeOptimizations", false, "Set to true to disable recipe optimizations. Use only if weird behaviour exhibited, and always contact the developer first!", false);
        doubleClickDuration = ConfigUtils.getInt(config, "general", "doubleClickDuration", 10, 0, 1200, "The duration of ticks that can pass between two clicks to be registered as a double-click.", false);
        boolean oldShowAllItemTypes = showAllItemTypes;
        showAllItemTypes = ConfigUtils.getBoolean(config, "general", "showAllItemTypes", ModCharset.INDEV, "Show all item types in Charset's main creative tab.", false);
        if (Loader.isModLoaded((String)"jei")) {
            showAllItemTypesJEI = ConfigUtils.getBoolean(config, "general", "showAllItemTypesJEI", true, "Show all item types in JustEnoughItems's recipe list.", true);
        }
        if (!event.isFirstTime() && oldShowAllItemTypes != showAllItemTypes) {
            SubItemProviderCache.clear();
        }
        if (event.isFirstTime()) {
            CharsetIMC.INSTANCE.loadConfig(config);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        AudioAPI.DATA_REGISTRY = new CharsetSimpleInstantiatingRegistry<AudioData>();
        AudioAPI.SINK_REGISTRY = new CharsetSimpleInstantiatingRegistry<AudioSink>();
        Capabilities.preInit();
        NotifyImplementation.init();
        ItemMaterialHeuristics.init(false);
        MinecraftForge.EVENT_BUS.register((Object)new CharsetLibEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)CharsetSounds.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)Scheduler.INSTANCE);
        Colorspaces.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        RecipeReplacement.PRIMARY.register();
        RecipeIngredientPatcher.PRIMARY.process(event.getRegistry().getValuesCollection());
        SubItemProviderCache.clear();
        FastRecipeLookup.clearRecipeLists();
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FluidExtraInformationHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SplashTextHandler());
        ClientCommandHandler.instance.func_71560_a((ICommand)CommandCharset.CLIENT);
        CommandCharset.register(new SubCommandClientCmdList("day", "Makes it day", "/time set 1200"));
        CommandCharset.register(new SubCommandClientCmdList("night", "Makes it night", "/time set 18000"));
        CommandCharset.register(new SubCommandClientCmdList("nice", "Makes it a sunny morning", "/time set 1200", "/weather clear"));
        CommandCharset.register(new SubCommandFog());
        CommandCharset.register(new SubCommandSetupTestWorld());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packet.registerPacket(1, PacketAudioData.class);
        packet.registerPacket(2, PacketAudioStop.class);
        packet.registerPacket(16, PacketNotification.class);
        packet.registerPacket(17, PacketPoint.class);
        packet.registerPacket(32, PacketCustomBlockDust.class);
        packet.registerPacket(48, PacketRequestScroll.class);
        MinecraftForge.EVENT_BUS.register((Object)ShiftScrollHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new DyeableItemWashHandler());
        MinecraftForge.EVENT_BUS.register((Object)new Todokete());
        Capabilities.init();
        DataSerializersCharset.init();
        UtilProxyCommon.proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new DebugInfoProvider());
        CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(AudioData.class).register(AudioDataDFPWM.class, AudioDataDFPWM::new);
        CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(AudioData.class).register(AudioDataGameSound.class, AudioDataGameSound::new);
        CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(AudioSink.class).register(AudioSinkBlock.class, AudioSinkBlock::new);
        CommandCharset.register(new SubCommandHelp(Side.CLIENT));
        CommandCharset.register(new SubCommandHelp(Side.SERVER));
        SubCommandAt at = new SubCommandAt();
        CommandCharset.register(new SubCommandHand(at));
        CommandCharset.register(at);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Capabilities.registerVanillaWrappers();
        IngredientGroup.registerDefaults();
        ItemMaterialHeuristics.init(true);
        SubItemProviderCache.clear();
        if (deathHandler.hasPredicate()) {
            MinecraftForge.EVENT_BUS.register((Object)deathHandler);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)CommandCharset.SERVER);
        NotifyImplementation.instance.registerServerCommands(event);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        FastRecipeLookup.clearRecipeLists();
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        AudioStreamManager.INSTANCE.removeAll();
    }

    static {
        calendar = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Calendar>(){

            public Calendar get() {
                return Calendar.getInstance();
            }
        }, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        deathHandler = new PlayerDeathHandler();
    }
}

