/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.api.audio;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.api.CharsetAPI;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;

public abstract class AudioSink
extends IForgeRegistryEntry.Impl<AudioSink>
implements IAudioReceiver {
    public abstract World getWorld();

    public abstract Vec3d getPos();

    public abstract float getDistance();

    public abstract float getVolume();

    @Override
    public boolean receive(AudioPacket packet) {
        return packet.add(this);
    }

    public void writeData(ByteBuf buffer) {
        buffer.writeShort(CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(AudioSink.class).getId(this));
    }

    public void readData(ByteBuf buffer) {
    }

    public static AudioSink create(ByteBuf buffer) {
        try {
            AudioSink sink = CharsetAPI.INSTANCE.findSimpleInstantiatingRegistry(AudioSink.class).create(buffer.readUnsignedShort());
            sink.readData(buffer);
            return sink;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

