/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.blay09.mods.cookingforblockheads.block.BlockFridge;
import net.blay09.mods.cookingforblockheads.block.BlockMilkJar;
import net.blay09.mods.cookingforblockheads.block.BlockOven;
import net.blay09.mods.cookingforblockheads.block.BlockToaster;
import net.blay09.mods.cookingforblockheads.tile.TileFridge;
import net.blay09.mods.cookingforblockheads.tile.TileMilkJar;
import net.blay09.mods.cookingforblockheads.tile.TileOven;
import net.blay09.mods.cookingforblockheads.tile.TileToaster;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@WailaPlugin
public class WailaProvider
implements IWailaPlugin {
    public void register(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new MilkJarDataProvider(), BlockMilkJar.class);
        registrar.registerBodyProvider((IWailaDataProvider)new ToasterDataProvider(), BlockToaster.class);
        registrar.registerBodyProvider((IWailaDataProvider)new OvenDataProvider(), BlockOven.class);
        registrar.registerBodyProvider((IWailaDataProvider)new FridgeDataProvider(), BlockFridge.class);
    }

    public static class FridgeDataProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return ItemStack.field_190927_a;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof TileFridge) {
                TileFridge tileFridge = (TileFridge)tileEntity;
                if (tileFridge.hasIceUpgrade()) {
                    list.add(I18n.func_135052_a((String)"waila.cookingforblockheads:ice_unit", (Object[])new Object[0]));
                }
                if (tileFridge.hasPreservationUpgrade()) {
                    list.add(I18n.func_135052_a((String)"waila.cookingforblockheads:preservation_chamber", (Object[])new Object[0]));
                }
            }
            return list;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, BlockPos pos) {
            if (tileEntity != null) {
                tileEntity.func_189515_b(tagCompound);
            }
            return tagCompound;
        }
    }

    public static class OvenDataProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return ItemStack.field_190927_a;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileOven tileOven;
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof TileOven && (tileOven = (TileOven)tileEntity).hasPowerUpgrade()) {
                list.add(I18n.func_135052_a((String)"waila.cookingforblockheads:heating_unit", (Object[])new Object[0]));
            }
            return list;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, BlockPos pos) {
            if (tileEntity != null) {
                tileEntity.func_189515_b(tagCompound);
            }
            return tagCompound;
        }
    }

    public static class ToasterDataProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return ItemStack.field_190927_a;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileToaster tileToaster;
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof TileToaster && (tileToaster = (TileToaster)tileEntity).isActive()) {
                list.add(I18n.func_135052_a((String)"waila.cookingforblockheads:toast_progress", (Object[])new Object[]{(int)(tileToaster.getToastProgress() * 100.0f)}) + "%");
            }
            return list;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, BlockPos pos) {
            if (tileEntity != null) {
                tileEntity.func_189515_b(tagCompound);
            }
            return tagCompound;
        }
    }

    public static class MilkJarDataProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return ItemStack.field_190927_a;
        }

        public List<String> getWailaHead(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof TileMilkJar) {
                TileMilkJar tileMilkJar = (TileMilkJar)tileEntity;
                list.add(I18n.func_135052_a((String)"waila.cookingforblockheads:milk_stored", (Object[])new Object[]{(int)tileMilkJar.getMilkAmount(), (int)tileMilkJar.getMilkCapacity()}));
            }
            return list;
        }

        public List<String> getWailaTail(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            return list;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, BlockPos pos) {
            if (tileEntity != null) {
                tileEntity.func_189515_b(tagCompound);
            }
            return tagCompound;
        }
    }
}

