/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomeOvergrown
extends BasicUndergroundBiome {
    int rootChance;
    int dirtChance;

    public UndergroundBiomeOvergrown() {
        super(Blocks.field_150341_Y.func_176223_P(), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)), null);
    }

    @Override
    public void finalCeilingPass(World world, BlockPos pos) {
        if (this.rootChance > 0 && world.field_73012_v.nextInt(this.rootChance) == 0) {
            int i;
            int count = 0;
            for (i = 0; i < 20; ++i) {
                BlockPos checkPos = pos.func_177982_a(0, -i, 0);
                if (!this.isFloor(world, checkPos, world.func_180495_p(checkPos))) continue;
                count = i;
                break;
            }
            for (i = 0; i <= count; ++i) {
                BlockPos placePos = pos.func_177982_a(0, -i, 0);
                world.func_175656_a(placePos, Blocks.field_150364_r.func_176223_P());
            }
        }
    }

    @Override
    public void fillFloor(World world, BlockPos pos, IBlockState state) {
        if (this.dirtChance > 0 && world.field_73012_v.nextInt(this.dirtChance) == 0) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
        } else {
            super.fillFloor(world, pos, state);
        }
    }

    @Override
    public void setupConfig(String category) {
        this.rootChance = ModuleLoader.config.getInt("Root Chance", category, 40, 0, Integer.MAX_VALUE, "The higher, the less roots will spawn");
        this.dirtChance = ModuleLoader.config.getInt("Dirt Chance", category, 2, 0, Integer.MAX_VALUE, "The higher, the less dirt will spawn");
    }
}

