/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityWraith
extends EntityZombie {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("quark:entities/wraith");
    private static final DataParameter<Integer> SOUND_TYPE = EntityDataManager.func_187226_a(EntityWraith.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final String TAG_SOUND_TYPE = "SoundType";
    private static SoundEvent[][] SOUNDS = new SoundEvent[][]{{SoundEvents.field_187757_eG, SoundEvents.field_187761_eI, SoundEvents.field_187759_eH}, {SoundEvents.field_187558_ak, SoundEvents.field_187562_am, SoundEvents.field_187560_al}, {SoundEvents.field_187697_dL, SoundEvents.field_187703_dN, SoundEvents.field_187700_dM}, {SoundEvents.field_187660_W, SoundEvents.field_187666_Z, SoundEvents.field_187663_X}, {SoundEvents.field_187696_ck, SoundEvents.field_187717_cr, SoundEvents.field_187708_co}, {SoundEvents.field_187636_O, SoundEvents.field_187642_Q, SoundEvents.field_187639_P}, {SoundEvents.field_187857_gE, SoundEvents.field_187863_gH, SoundEvents.field_187859_gF}, {SoundEvents.field_187910_gj, SoundEvents.field_187912_gl, SoundEvents.field_187911_gk}, {SoundEvents.field_190026_er, SoundEvents.field_190029_eu, SoundEvents.field_190028_et}, {SoundEvents.field_187899_gZ, SoundEvents.field_187934_hh, SoundEvents.field_187530_aT}, {SoundEvents.field_187854_fc, SoundEvents.field_187864_fh, SoundEvents.field_187856_fd}, {SoundEvents.field_187817_fK, SoundEvents.field_187821_fM, SoundEvents.field_187819_fL}, {null, SoundEvents.field_187570_aq, SoundEvents.field_187568_ap}, {SoundEvents.field_187529_aS, SoundEvents.field_187531_aU, SoundEvents.field_187530_aT}, {SoundEvents.field_187935_hi, SoundEvents.field_187938_hl, SoundEvents.field_187937_hk}, {SoundEvents.field_187920_gt, SoundEvents.field_187923_gw, SoundEvents.field_187921_gu}, {SoundEvents.field_187594_A, SoundEvents.field_187603_D, SoundEvents.field_187600_C}, {SoundEvents.field_191260_dz, SoundEvents.field_191254_dE, SoundEvents.field_191252_dC}};

    public EntityWraith(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SOUND_TYPE, (Object)-1);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(field_110186_bp).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    protected SoundEvent func_184639_G() {
        return this.getSoundForIndex(0);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.getSoundForIndex(1);
    }

    protected SoundEvent func_184615_bR() {
        return this.getSoundForIndex(2);
    }

    protected float func_70647_i() {
        return this.field_70146_Z.nextFloat() * 0.1f + 0.75f;
    }

    public int getSoundType() {
        return (Integer)this.field_70180_af.func_187225_a(SOUND_TYPE);
    }

    public SoundEvent getSoundForIndex(int i) {
        int soundType = this.getSoundType();
        if (soundType == -1) {
            return null;
        }
        return SOUNDS[soundType][i];
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getSoundType() == -1) {
            this.field_70180_af.func_187227_b(SOUND_TYPE, (Object)this.field_70146_Z.nextInt(SOUNDS.length));
        }
        AxisAlignedBB aabb = this.func_174813_aQ();
        double x = aabb.field_72340_a + Math.random() * (aabb.field_72336_d - aabb.field_72340_a);
        double y = aabb.field_72338_b + Math.random() * (aabb.field_72337_e - aabb.field_72338_b);
        double z = aabb.field_72339_c + Math.random() * (aabb.field_72334_f - aabb.field_72339_c);
        this.func_130014_f_().func_175688_a(EnumParticleTypes.TOWN_AURA, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean did = super.func_70652_k(entityIn);
        if (did) {
            if (entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 1));
            }
            double dx = this.field_70165_t - entityIn.field_70165_t;
            double dz = this.field_70161_v - entityIn.field_70161_v;
            Vec3d vec = new Vec3d(dx, 0.0, dz).func_72432_b().func_72441_c(0.0, 0.5, 0.0).func_72432_b().func_186678_a(0.85);
            this.field_70159_w = vec.field_72450_a;
            this.field_70181_x = vec.field_72448_b;
            this.field_70179_y = vec.field_72449_c;
        }
        return did;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76379_h) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(TAG_SOUND_TYPE, this.getSoundType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(SOUND_TYPE, (Object)compound.func_74762_e(TAG_SOUND_TYPE));
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b - 1.0, this.field_70161_v);
        return super.func_70601_bi() && this.func_130014_f_().func_180495_p(blockpos).func_177230_c() == Blocks.field_150425_aM;
    }
}

