/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class BoatSails
extends Feature {
    private static DataParameter<ItemStack> bannerData;
    private static final String TAG_BANNER = "quark:banner";

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        bannerData = EntityDataManager.func_187226_a(EntityBoat.class, (DataSerializer)DataSerializers.field_187196_f);
    }

    @SubscribeEvent
    public void onEntityInit(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityBoat) {
            EntityDataManager manager = event.getEntity().func_184212_Q();
            manager.func_187214_a(bannerData, (Object)ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        if (target instanceof EntityBoat && !target.func_184188_bt().contains(player)) {
            ItemStack banner = BoatSails.getBanner((EntityBoat)target);
            if (!banner.func_190926_b()) {
                return;
            }
            EnumHand hand = EnumHand.MAIN_HAND;
            ItemStack stack = player.func_184614_ca();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBanner)) {
                stack = player.func_184592_cb();
                hand = EnumHand.OFF_HAND;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBanner) {
                ItemStack copyStack = stack.func_77946_l();
                player.func_184609_a(hand);
                target.func_184212_Q().func_187227_b(bannerData, (Object)copyStack);
                NBTTagCompound cmp = new NBTTagCompound();
                copyStack.func_77955_b(cmp);
                target.getEntityData().func_74782_a(TAG_BANNER, (NBTBase)cmp);
                if (!event.getWorld().field_72995_K) {
                    event.setCanceled(true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() <= 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                }
            }
        }
    }

    public static ItemStack getBanner(EntityBoat boat) {
        return (ItemStack)boat.func_184212_Q().func_187225_a(bannerData);
    }

    public static void onBoatUpdate(EntityBoat boat) {
        NBTTagCompound cmp;
        ItemStack nbtStack;
        if (boat.func_130014_f_().field_72995_K || !ModuleLoader.isFeatureEnabled(BoatSails.class)) {
            return;
        }
        ItemStack dataStack = (ItemStack)boat.func_184212_Q().func_187225_a(bannerData);
        if (dataStack != (nbtStack = new ItemStack(cmp = boat.getEntityData().func_74775_l(TAG_BANNER)))) {
            boat.func_184212_Q().func_187227_b(bannerData, (Object)nbtStack);
        }
    }

    public static void dropBoatBanner(EntityBoat boat) {
        if (!ModuleLoader.isFeatureEnabled(BoatSails.class)) {
            return;
        }
        ItemStack banner = BoatSails.getBanner(boat);
        if (!banner.func_190926_b()) {
            banner.func_190920_e(1);
            boat.func_70099_a(banner, 0.0f);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

