/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.quark.base.lib.LibObfuscation;
import vazkii.quark.vanity.client.emotes.CustomEmoteDescriptor;
import vazkii.quark.vanity.client.emotes.EmoteBase;
import vazkii.quark.vanity.client.emotes.EmoteDescriptor;
import vazkii.quark.vanity.client.emotes.TemplateSourcedEmote;

public final class EmoteHandler {
    public static final String CUSTOM_EMOTE_NAMESPACE = "quark_custom";
    public static final String CUSTOM_PREFIX = "custom:";
    public static Map<String, EmoteDescriptor> emoteMap = new LinkedHashMap<String, EmoteDescriptor>();
    private static WeakHashMap<EntityPlayer, EmoteBase> playerEmotes = new WeakHashMap();
    private static List<EntityPlayer> updatedPlayers = new ArrayList<EntityPlayer>();
    private static int count;

    public static void addEmote(String name, Class<? extends EmoteBase> clazz) {
        EmoteDescriptor desc = new EmoteDescriptor(clazz, name, name, count++);
        emoteMap.put(name, desc);
    }

    public static void addEmote(String name) {
        EmoteHandler.addEmote(name, TemplateSourcedEmote.class);
    }

    public static void addCustomEmote(String name) {
        String reg = CUSTOM_PREFIX + name;
        CustomEmoteDescriptor desc = new CustomEmoteDescriptor(name, reg, count++);
        emoteMap.put(reg, desc);
    }

    public static void putEmote(AbstractClientPlayer player, String emoteName) {
        if (emoteMap.containsKey(emoteName)) {
            EmoteHandler.putEmote(player, emoteMap.get(emoteName));
        }
    }

    public static void putEmote(AbstractClientPlayer player, EmoteDescriptor desc) {
        if (player == null || playerEmotes.containsKey(player)) {
            return;
        }
        ModelBiped model = EmoteHandler.getPlayerModel(player);
        ModelBiped armorModel = EmoteHandler.getPlayerArmorModel(player);
        ModelBiped armorLegModel = EmoteHandler.getPlayerArmorLegModel(player);
        if (model.field_78116_c.field_78796_g < 0.0f) {
            model.field_78116_c.field_78796_g = (float)Math.PI * 2 - model.field_78116_c.field_78796_g;
        }
        EmoteBase emote = desc.instantiate((EntityPlayer)player, model, armorModel, armorLegModel);
        emote.startAllTimelines();
        playerEmotes.put((EntityPlayer)player, emote);
    }

    public static void updateEmotes(Entity e) {
        AbstractClientPlayer player;
        if (e instanceof AbstractClientPlayer && playerEmotes.containsKey(player = (AbstractClientPlayer)e)) {
            EmoteBase emote = playerEmotes.get(player);
            boolean done = emote.isDone();
            if (!done) {
                emote.update(!updatedPlayers.contains(player));
            }
            updatedPlayers.add((EntityPlayer)player);
        }
    }

    public static void onRenderTick(Minecraft mc, boolean start) {
        if (start) {
            EmoteHandler.clearPlayerList();
        } else {
            WorldClient world = mc.field_71441_e;
            if (world == null) {
                return;
            }
            for (EntityPlayer player : world.field_73010_i) {
                EmoteHandler.updateEmoteTime(player);
            }
        }
    }

    private static void updateEmoteTime(EntityPlayer e) {
        AbstractClientPlayer player;
        if (e instanceof AbstractClientPlayer && playerEmotes.containsKey(player = (AbstractClientPlayer)e)) {
            EmoteBase emote = playerEmotes.get(player);
            boolean done = emote.isDone();
            if (done) {
                playerEmotes.remove(player);
                EmoteHandler.resetModel(EmoteHandler.getPlayerModel(player));
                EmoteHandler.resetModel(EmoteHandler.getPlayerArmorModel(player));
                EmoteHandler.resetModel(EmoteHandler.getPlayerArmorLegModel(player));
            } else {
                emote.updateTime();
            }
        }
    }

    private static void clearPlayerList() {
        updatedPlayers.clear();
    }

    public static EmoteBase getPlayerEmote(EntityPlayer player) {
        return playerEmotes.get(player);
    }

    private static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager manager = mc.func_175598_ae();
        return (RenderPlayer)manager.getSkinMap().get(player.func_175154_l());
    }

    private static ModelBiped getPlayerModel(AbstractClientPlayer player) {
        return EmoteHandler.getRenderPlayer(player).func_177087_b();
    }

    private static ModelBiped getPlayerArmorModel(AbstractClientPlayer player) {
        List list = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)EmoteHandler.getRenderPlayer(player), (String[])LibObfuscation.LAYER_RENDERERS);
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof LayerBipedArmor)) continue;
            return (ModelBiped)ReflectionHelper.getPrivateValue(LayerArmorBase.class, (Object)((LayerArmorBase)list.get(i)), (String[])LibObfuscation.MODEL_ARMOR);
        }
        return null;
    }

    private static ModelBiped getPlayerArmorLegModel(AbstractClientPlayer player) {
        List list = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)EmoteHandler.getRenderPlayer(player), (String[])LibObfuscation.LAYER_RENDERERS);
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof LayerBipedArmor)) continue;
            return (ModelBiped)ReflectionHelper.getPrivateValue(LayerArmorBase.class, (Object)((LayerArmorBase)list.get(i)), (String[])LibObfuscation.MODEL_LEGGINGS);
        }
        return null;
    }

    private static void resetModel(ModelBiped model) {
        ImmutableSet.of((Object)model.field_78116_c, (Object)model.field_178720_f, (Object)model.field_78115_e, (Object)model.field_178724_i, (Object)model.field_178723_h, (Object)model.field_178722_k, (Object[])new ModelRenderer[]{model.field_178721_j}).forEach(EmoteHandler::resetPart);
    }

    private static void resetPart(ModelRenderer part) {
        part.field_82907_q = 0.0f;
        part.field_82908_p = 0.0f;
        part.field_82906_o = 0.0f;
        part.field_78808_h = 0.0f;
    }
}

