/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.entity;

import com.mojang.authlib.GameProfile;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.quark.oddities.feature.TotemOfHolding;

public class EntityTotemOfHolding
extends Entity {
    private static final String TAG_ITEMS = "storedItems";
    private static final String TAG_DYING = "dying";
    private static final String OWNER = "owner";
    private static final DataParameter<Boolean> DYING = EntityDataManager.func_187226_a(EntityTotemOfHolding.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final int DEATH_TIME = 40;
    int deathTicks = 0;
    String owner;
    List<ItemStack> storedItems = new LinkedList<ItemStack>();

    public EntityTotemOfHolding(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.func_70105_a(0.5f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DYING, (Object)false);
    }

    public void addItem(ItemStack stack) {
        this.storedItems.add(stack);
    }

    public void setOwner(EntityPlayer player) {
        this.owner = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
    }

    EntityPlayer getOwnerEntity() {
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            String uuid = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()).toString();
            if (!uuid.equals(this.owner)) continue;
            return player;
        }
        return null;
    }

    public boolean func_85031_j(Entity e) {
        if (!this.field_70170_p.field_72995_K && e instanceof EntityPlayer) {
            EntityPlayer owner;
            if (!TotemOfHolding.anyoneCollect && e != (owner = this.getOwnerEntity())) {
                return false;
            }
            int drops = Math.min(this.storedItems.size(), 3 + this.field_70170_p.field_73012_v.nextInt(4));
            EntityPlayer player = (EntityPlayer)e;
            for (int i = 0; i < drops; ++i) {
                ItemStack stack = this.storedItems.remove(0);
                if (stack.func_77973_b() instanceof ItemArmor) {
                    ItemArmor armor = (ItemArmor)stack.func_77973_b();
                    EntityEquipmentSlot slot = armor.field_77881_a;
                    ItemStack curr = player.func_184582_a(slot);
                    if (curr.func_190926_b()) {
                        player.func_184201_a(slot, stack);
                        stack = null;
                    } else if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)curr) == 0) {
                        player.func_184201_a(slot, stack);
                        stack = curr;
                    }
                }
                if (stack == null || player.func_191521_c(stack)) continue;
                this.func_70099_a(stack, 0.0f);
            }
            if (this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.DAMAGE_INDICATOR, false, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, drops, 0.1, 0.5, 0.1, 0.0, new int[0]);
                ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.CRIT_MAGIC, false, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, drops, 0.4, 0.5, 0.4, 0.0, new int[0]);
            }
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70030_z() {
        EntityPlayer owner;
        super.func_70030_z();
        if (this.field_70128_L) {
            return;
        }
        if (TotemOfHolding.darkSoulsMode && (owner = this.getOwnerEntity()) != null && !this.field_70170_p.field_72995_K) {
            String ownerTotem = TotemOfHolding.getTotemUUID(owner);
            if (!this.func_110124_au().toString().equals(ownerTotem)) {
                this.dropEverythingAndDie();
            }
        }
        if (this.storedItems.isEmpty() && !this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(DYING, (Object)true);
        }
        if (this.isDying()) {
            if (this.deathTicks > 40) {
                this.func_70106_y();
            } else {
                ++this.deathTicks;
            }
        } else if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t, this.field_70163_u + (Math.random() - 0.5) * 0.2, this.field_70161_v, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5, new int[0]);
        }
    }

    private void dropEverythingAndDie() {
        if (!TotemOfHolding.destroyItems) {
            for (int i = 0; i < this.storedItems.size(); ++i) {
                this.func_70099_a(this.storedItems.get(i), 0.0f);
            }
        }
        this.storedItems.clear();
        this.func_70106_y();
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public boolean isDying() {
        return (Boolean)this.field_70180_af.func_187225_a(DYING);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c(TAG_ITEMS, 10);
        this.storedItems = new LinkedList<ItemStack>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cmp = list.func_150305_b(i);
            ItemStack stack = new ItemStack(cmp);
            this.storedItems.add(stack);
        }
        boolean dying = compound.func_74767_n(TAG_DYING);
        this.field_70180_af.func_187227_b(DYING, (Object)dying);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.storedItems) {
            NBTTagCompound cmp = new NBTTagCompound();
            stack.func_77955_b(cmp);
            list.func_74742_a((NBTBase)cmp);
        }
        compound.func_74782_a(TAG_ITEMS, (NBTBase)list);
        compound.func_74757_a(TAG_DYING, this.isDying());
    }
}

