/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.feature;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import vazkii.arl.recipe.BlacklistOreIngredient;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.handler.RecipeProcessor;
import vazkii.quark.base.module.Feature;
import vazkii.quark.decoration.block.BlockCustomChest;
import vazkii.quark.decoration.client.render.RenderTileCustomChest;
import vazkii.quark.decoration.tile.TileCustomChest;

public class VariedChests
extends Feature {
    public static final BlockChest.Type CUSTOM_TYPE_QUARK = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"QUARK", (Class[])new Class[0], (Object[])new Object[0]);
    public static final BlockChest.Type CUSTOM_TYPE_QUARK_TRAP = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"QUARK_TRAP", (Class[])new Class[0], (Object[])new Object[0]);
    public static final ResourceLocation TRAP_RESOURCE = new ResourceLocation("quark:textures/blocks/chests/trap.png");
    public static final ResourceLocation TRAP_DOUBLE_RESOURCE = new ResourceLocation("quark:textures/blocks/chests/trap_double.png");
    public static BlockCustomChest custom_chest;
    public static BlockCustomChest custom_chest_trap;
    boolean renameVanillaChests;
    boolean addLogRecipe;
    boolean reversionRecipe;
    private static boolean fixedTrappedChest;

    @Override
    public void setupConfig() {
        this.renameVanillaChests = this.loadPropBool("Rename vanilla chests to Oak (Trapped) Chest", "", true);
        this.addLogRecipe = this.loadPropBool("Add recipe to craft chests using Logs (makes 4 chests)", "", true);
        this.reversionRecipe = this.loadPropBool("Enable Conversion to Vanilla Chests", "Set this to true to add a recipe to convert any Quark chest to a vanilla one.\nUse this if some of your mods don't work with the ore dictionary key \"chestWood\".", false);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        custom_chest = new BlockCustomChest("custom_chest", CUSTOM_TYPE_QUARK);
        custom_chest_trap = new BlockCustomChest("custom_chest_trap", CUSTOM_TYPE_QUARK_TRAP);
        VariedChests.registerTile(TileCustomChest.class, "quark_chest");
        ModIntegrationHandler.addCharsetCarry((Block)custom_chest);
        ModIntegrationHandler.addCharsetCarry((Block)custom_chest_trap);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileCustomChest.class, (TileEntitySpecialRenderer)new RenderTileCustomChest());
    }

    @Override
    public void postPreInit(FMLPreInitializationEvent event) {
        if (this.renameVanillaChests) {
            Blocks.field_150486_ae.func_149663_c("oak_chest");
            Blocks.field_150447_bR.func_149663_c("oak_chest_trap");
        }
        RecipeProcessor.addWoodReplacements(new Block[]{Blocks.field_150486_ae});
        RecipeProcessor.addConsumer(VariedChests::fixTrappedChestRecipe);
        if (this.addLogRecipe) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150486_ae, (int)4), (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), ProxyRegistry.newStack((Block)Blocks.field_150364_r)});
        }
        int i = 1;
        for (ChestType type : ChestType.VALID_TYPES) {
            ItemStack out = ProxyRegistry.newStack((Block)custom_chest);
            custom_chest.setCustomType(out, type);
            RecipeHandler.addOreDictRecipe((ItemStack)out.func_77946_l(), (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), ProxyRegistry.newStack((Block)Blocks.field_150344_f, (int)1, (int)i)});
            if (this.addLogRecipe) {
                ItemStack outFour = out.func_77946_l();
                outFour.func_190920_e(4);
                RecipeHandler.addOreDictRecipe((ItemStack)outFour, (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), ProxyRegistry.newStack((Block)(i > 3 ? Blocks.field_150363_s : Blocks.field_150364_r), (int)1, (int)(i % 4))});
            }
            ItemStack outTrap = ProxyRegistry.newStack((Block)custom_chest_trap);
            custom_chest.setCustomType(outTrap, type);
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)outTrap, (Object[])new Object[]{out.func_77946_l(), ProxyRegistry.newStack((Block)Blocks.field_150479_bC)});
            ++i;
        }
        BlacklistOreIngredient wood = new BlacklistOreIngredient("plankWood", stack -> stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150344_f));
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150486_ae), (Object[])new Object[]{"WWW", "W W", "WWW", Character.valueOf('W'), wood});
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150438_bZ), (Object[])new Object[]{"I I", "ICI", " I ", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), "chestWood"});
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_190987_dv), (Object[])new Object[]{"S", "C", "S", Character.valueOf('S'), ProxyRegistry.newStack((Item)Items.field_190930_cZ), Character.valueOf('C'), "chest"});
        if (this.reversionRecipe) {
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)new ItemStack((Block)Blocks.field_150486_ae), (Object[])new Object[]{"chestWood"});
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)new ItemStack(Blocks.field_150447_bR), (Object[])new Object[]{"chestTrapped"});
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"chest", (ItemStack)ProxyRegistry.newStack((Block)custom_chest, (int)1, (int)Short.MAX_VALUE));
        OreDictionary.registerOre((String)"chest", (ItemStack)ProxyRegistry.newStack((Block)custom_chest_trap, (int)1, (int)Short.MAX_VALUE));
        OreDictionary.registerOre((String)"chest", (Block)Blocks.field_150486_ae);
        OreDictionary.registerOre((String)"chest", (Block)Blocks.field_150447_bR);
        OreDictionary.registerOre((String)"chestWood", (ItemStack)ProxyRegistry.newStack((Block)custom_chest, (int)1, (int)Short.MAX_VALUE));
        OreDictionary.registerOre((String)"chestWood", (Block)Blocks.field_150486_ae);
        OreDictionary.registerOre((String)"chestTrapped", (ItemStack)ProxyRegistry.newStack((Block)custom_chest_trap, (int)1, (int)Short.MAX_VALUE));
        OreDictionary.registerOre((String)"chestTrapped", (Block)Blocks.field_150447_bR);
    }

    private static void fixTrappedChestRecipe(IRecipe recipe) {
        if (fixedTrappedChest) {
            return;
        }
        if (recipe.getRegistryName().toString().equals("minecraft:trapped_chest")) {
            NonNullList ingredients = recipe.func_192400_c();
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingr = (Ingredient)ingredients.get(i);
                if (!(ingr instanceof OreIngredient)) continue;
                BlacklistOreIngredient chest = new BlacklistOreIngredient("chestWood", stack -> stack.func_77973_b() == Item.func_150898_a((Block)custom_chest));
                ingredients.set(i, chest);
                break;
            }
            fixedTrappedChest = true;
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        fixedTrappedChest = false;
    }

    public static enum ChestType {
        NONE(""),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak");

        public final String name;
        public final ResourceLocation nrmTex;
        public final ResourceLocation dblTex;
        public final ModelResourceLocation normalModel;
        public final ModelResourceLocation trapModel;
        public static final ChestType[] VALID_TYPES;
        public static final Map<String, ChestType> NAME_TO_TYPE;

        private ChestType(String name) {
            this.name = name;
            this.nrmTex = new ResourceLocation("quark:textures/blocks/chests/" + name + ".png");
            this.dblTex = new ResourceLocation("quark:textures/blocks/chests/" + name + "_double.png");
            this.normalModel = new ModelResourceLocation(new ResourceLocation("quark", "custom_chest_" + name), "inventory");
            this.trapModel = new ModelResourceLocation(new ResourceLocation("quark", "custom_chest_trap_" + name), "inventory");
        }

        public static ChestType getType(String type) {
            return NAME_TO_TYPE.containsKey(type) ? NAME_TO_TYPE.get(type) : NONE;
        }

        static {
            VALID_TYPES = new ChestType[]{SPRUCE, BIRCH, JUNGLE, ACACIA, DARK_OAK};
            NAME_TO_TYPE = new HashMap<String, ChestType>();
            for (ChestType type : VALID_TYPES) {
                NAME_TO_TYPE.put(type.name, type);
            }
        }
    }
}

