/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.feature;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.arl.client.RetexturedModel;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.base.module.Feature;
import vazkii.quark.decoration.block.BlockColoredFlowerPot;

public class ColoredFlowerPots
extends Feature {
    public static BlockColoredFlowerPot[] pots;
    public static boolean enableComparatorLogic;
    public static String[] overrides;
    private static Map<Pair<Item, Integer>, Integer> flowers;
    private static boolean loadedConfig;
    private static Set<Item> unsafeBlockColors;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        pots = new BlockColoredFlowerPot[EnumDyeColor.values().length];
        for (int i = 0; i < pots.length; ++i) {
            ColoredFlowerPots.pots[i] = new BlockColoredFlowerPot(EnumDyeColor.func_176764_b((int)i));
            RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)pots[i]), (Object[])new Object[]{ProxyRegistry.newStack((Item)Items.field_151162_bE), LibMisc.OREDICT_DYES.get(15 - i)});
        }
    }

    @Override
    public void setupConfig() {
        enableComparatorLogic = this.loadPropBool("Comparator Logic", "If true, filled flower pots will respond to comparators based on the contents.", true);
        overrides = this.loadPropStringList("Flower Overrides", "List of itemstacks to override default flower behavior, default checks for BlockBush.\nFormat is 'modid:name[:meta]->power'. Unset meta will default wildcard. Power refers to comparator power, non-zero makes it valid for a flower pot. Specific values:\n* 0 - not flower, blacklists from placing in a flower pot\n* 1 - mushroom\n* 4 - fern\n* 7 - flower\n* 10 - dead bush\n* 12 - sapling\n* 15 - cactus", new String[]{"biomesoplenty:mushroom->1", "biomesoplenty:flower_0->7", "biomesoplenty:flower_1->7", "biomesoplenty:sapling_0->12", "biomesoplenty:sapling_1->12", "biomesoplenty:sapling_2->12", "quark:glowshroom->1"});
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ColoredFlowerPots.loadFlowersFromConfig();
    }

    public static void loadFlowersFromConfig() {
        if (loadedConfig) {
            return;
        }
        loadedConfig = true;
        ColoredFlowerPots.registerFlower(new ItemStack((Block)Blocks.field_150434_aF), 15);
        ColoredFlowerPots.registerFlower(new ItemStack((Block)Blocks.field_150329_H, 1, BlockTallGrass.EnumType.FERN.func_177044_a()), 4);
        for (String line : overrides) {
            int power;
            String[] split = line.split("->");
            if (split.length != 2) {
                FMLLog.log.error("Invalid Quark flower pot override, expected format 'modid:name[:meta]->power'");
                continue;
            }
            String[] itemData = split[0].split(":");
            if (itemData.length < 2 || itemData.length > 3) {
                FMLLog.log.error("Invalid Quark flower pot override, expected format 'modid:name[:meta]->power'");
                continue;
            }
            try {
                power = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                power = -1;
            }
            if (power < 0 || power > 15) {
                FMLLog.log.error("Invalid Quark flower pot override, power must be a valid number from 0 to 15");
                continue;
            }
            ResourceLocation location = new ResourceLocation(itemData[0], itemData[1]);
            Item item = (Item)GameRegistry.findRegistry(Item.class).getValue(location);
            if (item == null || item == Items.field_190931_a) {
                FMLLog.log.debug("Unable to find item {} for Quark flower override", (Object)location.toString());
                continue;
            }
            if (itemData.length == 3) {
                int meta;
                try {
                    meta = Integer.parseInt(itemData[2]);
                }
                catch (NumberFormatException e) {
                    meta = -1;
                }
                if (meta < 0) {
                    FMLLog.log.error("Invalid Quark flower pot override, meta must be a valid positive number");
                    continue;
                }
                ColoredFlowerPots.registerFlower(new ItemStack(item, 1, meta), power);
                continue;
            }
            NonNullList subItems = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, subItems);
            for (ItemStack stack : subItems) {
                ColoredFlowerPots.registerFlower(stack, power);
            }
        }
    }

    public static boolean isFlower(ItemStack stack) {
        return ColoredFlowerPots.getFlowerComparatorPower(stack) > 0;
    }

    public static int getFlowerComparatorPower(ItemStack stack) {
        return flowers.computeIfAbsent((Pair<Item, Integer>)Pair.of((Object)stack.func_77973_b(), (Object)stack.func_77960_j()), key -> {
            Block block = Block.func_149634_a((Item)((Item)key.getLeft()));
            if (!(block instanceof BlockBush) || block instanceof BlockDoublePlant || block instanceof BlockTallGrass || block instanceof BlockCrops || block instanceof BlockLilyPad) {
                return 0;
            }
            if (block instanceof BlockSapling) {
                return 12;
            }
            if (block instanceof BlockDeadBush) {
                return 10;
            }
            if (block instanceof BlockMushroom) {
                return 1;
            }
            return 7;
        });
    }

    public static void registerFlower(ItemStack stack, int power) {
        flowers.put((Pair<Item, Integer>)Pair.of((Object)stack.func_77973_b(), (Object)stack.func_77960_j()), power);
    }

    public static int getStackBlockColorsSafe(ItemStack stack, @Nullable IBlockAccess world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b()) {
            return -1;
        }
        Item item = stack.func_77973_b();
        if (!unsafeBlockColors.contains(item)) {
            try {
                return ColoredFlowerPots.getStackBlockColors(stack, world, pos, index);
            }
            catch (Exception e) {
                new RuntimeException(item.getRegistryName() + " errored on getting flower pot block colors", e).printStackTrace();
                unsafeBlockColors.add(item);
            }
        }
        return Minecraft.func_71410_x().getItemColors().func_186728_a(stack, index);
    }

    public static int getStackBlockColors(ItemStack stack, @Nullable IBlockAccess world, @Nullable BlockPos pos, int index) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) {
            return -1;
        }
        ItemBlock item = (ItemBlock)stack.func_77973_b();
        IBlockState iblockstate = item.func_179223_d().func_176203_a(item.getMetadata(stack));
        return Minecraft.func_71410_x().func_184125_al().func_186724_a(iblockstate, world, pos, index);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ModelResourceLocation location = new ModelResourceLocation(pots[color.func_176765_a()].getRegistryName(), "contents=custom");
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)location, (String)("Error loading model for " + location));
            IBakedModel standard = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
            RetexturedModel finalModel = new RetexturedModel(standard, model, DefaultVertexFormats.field_176600_a, "plant");
            event.getModelRegistry().func_82595_a((Object)location, (Object)finalModel);
        }
    }

    static {
        flowers = new HashMap<Pair<Item, Integer>, Integer>();
        loadedConfig = false;
        unsafeBlockColors = new HashSet<Item>();
    }
}

