/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.feature;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.base.module.Feature;
import vazkii.quark.building.item.ItemTrowel;

public class UsageTicker
extends Feature {
    List<TickerElement> elements;
    boolean invert;
    int shiftLeft;
    int shiftRight;

    @Override
    public void setupConfig() {
        this.elements = new ArrayList<TickerElement>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            String config = "Enable " + WordUtils.capitalize((String)slot.func_188450_d());
            if (!this.loadPropBool(config, "", true)) continue;
            this.elements.add(new TickerElement(slot));
        }
        this.invert = this.loadPropBool("Invert Displays", "Switch the armor display to the off hand side and the hand display to the main hand side", false);
        this.shiftLeft = this.loadPropInt("Left Side Offeset", "", 0);
        this.shiftRight = this.loadPropInt("Right Side Offset", "", 0);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                this.elements.forEach(ticker -> ticker.tick(event, (EntityPlayer)mc.field_71439_g));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ScaledResolution res = event.getResolution();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float pticks = event.getPartialTicks();
            this.elements.forEach(arg_0 -> this.lambda$renderHUD$1(res, (EntityPlayer)player, pticks, arg_0));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    private /* synthetic */ void lambda$renderHUD$1(ScaledResolution res, EntityPlayer player, float pticks, TickerElement ticker) {
        ticker.render(res, player, this.invert, pticks);
    }

    class TickerElement {
        private static final int MAX_TIME = 60;
        private static final int ANIM_TIME = 5;
        int liveTicks;
        EntityEquipmentSlot slot;
        ItemStack currStack = ItemStack.field_190927_a;
        int currCount;

        public TickerElement(EntityEquipmentSlot slot) {
            this.slot = slot;
        }

        @SideOnly(value=Side.CLIENT)
        public void tick(TickEvent.ClientTickEvent event, EntityPlayer player) {
            ItemStack heldStack = this.getStack(player).func_77946_l();
            int count = 0;
            count = this.getStackCount(player, heldStack);
            if ((heldStack = this.getDisplayedStack(player, heldStack, count)).func_190926_b()) {
                this.liveTicks = 0;
            } else if (this.shouldChange(heldStack, this.currStack, count, this.currCount)) {
                boolean animatingOut;
                boolean done = this.liveTicks == 0;
                boolean animatingIn = this.liveTicks > 55;
                boolean bl = animatingOut = this.liveTicks < 5 && !done;
                if (animatingOut) {
                    this.liveTicks = 60 - this.liveTicks;
                } else if (!animatingIn) {
                    this.liveTicks = !done ? 55 : 60;
                }
            } else if (this.liveTicks > 0) {
                --this.liveTicks;
            }
            this.currCount = count;
            this.currStack = heldStack;
        }

        @SideOnly(value=Side.CLIENT)
        public void render(ScaledResolution res, EntityPlayer player, boolean invert, float partialTicks) {
            if (this.liveTicks > 0) {
                float mul;
                float animProgress = this.liveTicks < 5 ? Math.max(0.0f, (float)this.liveTicks - partialTicks) / 5.0f : Math.min(5.0f, (float)(60 - this.liveTicks) + partialTicks) / 5.0f;
                float anim = -animProgress * (animProgress - 2.0f) * 20.0f;
                float x = res.func_78326_a() / 2;
                float y = (float)res.func_78328_b() - anim;
                int armorWidth = 80;
                int heldWidth = 40;
                int barWidth = 190;
                boolean armor = this.slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR;
                EnumHandSide primary = player.func_184591_cq();
                EnumHandSide ourSide = armor != invert ? primary : primary.func_188468_a();
                int slots = armor ? 4 : 2;
                int index = slots - this.slot.func_188454_b() - 1;
                float f = mul = ourSide == EnumHandSide.LEFT ? -1.0f : 1.0f;
                if (ourSide != primary && !player.func_184586_b(EnumHand.OFF_HAND).func_190926_b()) {
                    barWidth += 58;
                }
                Minecraft mc = Minecraft.func_71410_x();
                x += (float)(barWidth / 2) * mul + (float)(index * 20);
                if (ourSide == EnumHandSide.LEFT) {
                    x -= (float)(slots * 20);
                    x += (float)UsageTicker.this.shiftLeft;
                } else {
                    x += (float)UsageTicker.this.shiftRight;
                }
                ItemStack stack = this.getRenderedStack(player);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                RenderHelper.func_74520_c();
                mc.func_175599_af().func_180450_b(stack, 0, 0);
                mc.func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, 0, 0);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean shouldChange(ItemStack currStack, ItemStack prevStack, int currentTotal, int pastTotal) {
            return !prevStack.func_77969_a(currStack) || currentTotal != pastTotal;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getStack(EntityPlayer player) {
            return player.func_184582_a(this.slot);
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getDisplayedStack(EntityPlayer player, ItemStack stack, int count) {
            boolean verifySize = true;
            if (stack.func_77973_b() instanceof ItemBow && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) == 0) {
                stack = new ItemStack(Items.field_151032_g);
                verifySize = false;
            }
            if (stack.func_77973_b() instanceof ItemTrowel) {
                stack = ItemTrowel.getLastStack(stack);
                verifySize = false;
            }
            if (!stack.func_77985_e() && this.slot.func_188453_a() == EntityEquipmentSlot.Type.HAND) {
                return ItemStack.field_190927_a;
            }
            if (verifySize && stack.func_77985_e() && count == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getRenderedStack(EntityPlayer player) {
            int count;
            ItemStack stack = this.getStack(player);
            ItemStack displayStack = this.getDisplayedStack(player, stack, count = this.getStackCount(player, stack)).func_77946_l();
            if (displayStack != stack) {
                count = this.getStackCount(player, displayStack);
            }
            displayStack.func_190920_e(count);
            return displayStack;
        }

        @SideOnly(value=Side.CLIENT)
        public int getStackCount(EntityPlayer player, ItemStack stack) {
            if (!stack.func_77985_e()) {
                return 1;
            }
            Predicate pred = stackAt -> stack.func_77969_a(stackAt);
            if (stack.func_77973_b() == Items.field_151032_g) {
                pred = stackAt -> stackAt.func_77973_b() instanceof ItemArrow;
            }
            int total = 0;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt2 = player.field_71071_by.func_70301_a(i);
                if (!pred.apply((Object)stackAt2)) continue;
                total += stackAt2.func_190916_E();
            }
            return total;
        }
    }
}

