/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.feature;

import java.util.List;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;

public class PistonsPushPullItems
extends Feature {
    static float force = 0.48f;

    @Override
    public void setupConfig() {
        force = (float)this.loadPropDouble("Push Strength", "", force);
    }

    public static void onPistonUpdate(TileEntityPiston piston) {
        boolean sticky;
        if (!ModuleLoader.isFeatureEnabled(PistonsPushPullItems.class) || piston.func_145831_w().field_72995_K) {
            return;
        }
        IBlockState state = piston.func_174927_b();
        boolean pulling = state.func_177230_c() != Blocks.field_150332_K;
        boolean bl = sticky = state.func_177230_c() == Blocks.field_150320_F || state.func_177227_a().contains(BlockPistonExtension.field_176325_b) && state.func_177229_b((IProperty)BlockPistonExtension.field_176325_b) == BlockPistonExtension.EnumPistonType.STICKY;
        if (pulling != sticky) {
            return;
        }
        EnumFacing face = piston.func_174930_e();
        AxisAlignedBB aabb = new AxisAlignedBB(piston.func_174877_v().func_177967_a(face, pulling ? 2 : 1));
        List items = piston.func_145831_w().func_72872_a(EntityItem.class, aabb);
        for (EntityItem entity : items) {
            PistonsPushPullItems.onEntityHandled(entity, face, sticky);
        }
    }

    private static void onEntityHandled(EntityItem entity, EnumFacing face, boolean sticky) {
        if (sticky) {
            face = face.func_176734_d();
        }
        World world = entity.func_130014_f_();
        if (sticky) {
            BlockPos offsetPos = entity.func_180425_c().func_177972_a(face);
            boolean closeToEdge = new BlockPos(entity.field_70165_t + (double)face.func_82601_c() * 0.5, entity.field_70163_u + (double)face.func_96559_d() * 0.5, entity.field_70161_v + (double)face.func_82599_e() * 0.5).equals((Object)offsetPos);
            if (closeToEdge) {
                PistonsPushPullItems.nudgeItem(world, entity, face, false);
            }
        } else {
            PistonsPushPullItems.nudgeItem(world, entity, face, true);
        }
    }

    private static void nudgeItem(World world, EntityItem entity, EnumFacing whichWay, boolean showParticles) {
        float x = force * (float)whichWay.func_82601_c();
        float y = force * (float)whichWay.func_96559_d();
        float z = force * (float)whichWay.func_82599_e();
        float px = x == 0.0f ? 0.4f : 0.0f;
        float py = y == 0.0f ? 0.4f : 0.0f;
        float pz = z == 0.0f ? 0.4f : 0.0f;
        entity.func_70024_g((double)x, (double)y, (double)z);
        if (showParticles && world instanceof WorldServer) {
            ((WorldServer)world).func_175739_a(EnumParticleTypes.CRIT, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 12, (double)px, (double)py, (double)pz, 0.0, new int[0]);
        }
    }
}

