/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.common;

import com.progwml6.natura.Natura;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.item.ItemBlockMeta;

@SideOnly(value=Side.CLIENT)
public final class ModelRegisterUtil {
    public static final String VARIANT_INVENTORY = "inventory";

    public static void registerItemModel(ItemStack itemStack, ResourceLocation name) {
        if (!itemStack.func_190926_b() && name != null) {
            ModelLoader.registerItemVariants((Item)itemStack.func_77973_b(), (ResourceLocation[])new ResourceLocation[]{name});
            ModelLoader.setCustomModelResourceLocation((Item)itemStack.func_77973_b(), (int)itemStack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(name, VARIANT_INVENTORY));
        }
    }

    public static ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = null;
        if (item != null) {
            itemLocation = item.getRegistryName();
        }
        if (itemLocation != null) {
            itemLocation = ModelRegisterUtil.registerIt(item, itemLocation);
        }
        return itemLocation;
    }

    public static ResourceLocation registerItemModel(Block block) {
        return ModelRegisterUtil.registerItemModel(Item.func_150898_a((Block)block));
    }

    public static void registerItemBlockMeta(Block block) {
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            if (item instanceof ItemBlockMeta) {
                ((ItemBlockMeta)item).registerItemModels();
            } else {
                Natura.log.error("Trying to register an ItemBlockMeta model for a non itemblockmeta block: " + block.getRegistryName());
            }
        }
    }

    public static void registerItemModel(Item item, int meta) {
        ModelRegisterUtil.registerItemModel(item, meta, VARIANT_INVENTORY);
    }

    public static void registerItemModel(Item item, int meta, String variant) {
        if (item != null) {
            ModelRegisterUtil.registerItemModel(item, meta, item.getRegistryName(), variant);
        }
    }

    public static void registerItemModel(Item item, int meta, ResourceLocation location, String variant) {
        if (item != null && !StringUtils.func_151246_b((String)variant)) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
        }
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return new ModelResourceLocation(location, ModelRegisterUtil.VARIANT_INVENTORY);
            }
        });
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    private ModelRegisterUtil() {
    }
}

