/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.NumberedOreDictStack;
import zmaster587.libVulpes.tile.TileEntityMachine;

public class RecipesMachine {
    public HashMap<Class<Object>, List<IRecipe>> recipeList = new HashMap();
    private static RecipesMachine instance = new RecipesMachine();

    public static RecipesMachine getInstance() {
        return instance;
    }

    public void clearRecipes(Class<? extends TileEntityMachine> clazz) {
        this.recipeList.get(clazz).clear();
    }

    public void addRecipe(Class clazz, Object[] out, int timeRequired, int power, Object ... inputs) {
        List<IRecipe> recipes = this.getRecipes(clazz);
        if (recipes == null) {
            recipes = new LinkedList<IRecipe>();
            this.recipeList.put(clazz, recipes);
        }
        HashMap<Integer, String> oreDict = new HashMap<Integer, String>();
        LinkedList<List<ItemStack>> stack = new LinkedList<List<ItemStack>>();
        ArrayList<FluidStack> inputFluidStacks = new ArrayList<FluidStack>();
        try {
            for (int i = 0; i < inputs.length; ++i) {
                LinkedList<ItemStack> innerList = new LinkedList<ItemStack>();
                if (inputs[i] != null) {
                    if (inputs[i] instanceof String) {
                        oreDict.put(i, (String)inputs[i]);
                        for (ItemStack itemStack : OreDictionary.getOres((String)((String)inputs[i]))) {
                            innerList.add(itemStack.func_77946_l());
                        }
                    } else if (inputs[i] instanceof NumberedOreDictStack) {
                        oreDict.put(i, ((NumberedOreDictStack)inputs[i]).ore);
                        for (ItemStack itemStack : OreDictionary.getOres((String)((NumberedOreDictStack)inputs[i]).getOre())) {
                            int number = ((NumberedOreDictStack)inputs[i]).getNumber();
                            ItemStack stack2 = itemStack.func_77946_l();
                            stack2.func_190920_e(number);
                            innerList.add(stack2);
                        }
                    } else if (inputs[i] instanceof FluidStack) {
                        inputFluidStacks.add((FluidStack)inputs[i]);
                    } else {
                        if (inputs[i] instanceof Item) {
                            inputs[i] = new ItemStack((Item)inputs[i]);
                        } else if (inputs[i] instanceof Block) {
                            inputs[i] = new ItemStack((Block)inputs[i]);
                        }
                        innerList.add((ItemStack)inputs[i]);
                    }
                }
                if (innerList.isEmpty()) continue;
                stack.add(innerList);
            }
            ArrayList<ItemStack> outputItem = new ArrayList<ItemStack>();
            ArrayList<FluidStack> outputFluidStacks = new ArrayList<FluidStack>();
            for (Object outputObject : out) {
                if (outputObject instanceof ItemStack) {
                    outputItem.add((ItemStack)outputObject);
                    continue;
                }
                outputFluidStacks.add((FluidStack)outputObject);
            }
            Recipe recipe = inputFluidStacks.isEmpty() && outputFluidStacks.isEmpty() ? new Recipe(outputItem, stack, timeRequired, power, oreDict) : new Recipe(outputItem, stack, outputFluidStacks, inputFluidStacks, timeRequired, power, oreDict);
            if (recipes.contains(recipe)) {
                LibVulpes.logger.info("Overwriting recipe " + recipes.remove(recipe));
            }
            recipes.add(recipe);
        }
        catch (ClassCastException e) {
            String message = e.getLocalizedMessage();
            for (StackTraceElement element : e.getStackTrace()) {
                message = message + "\n\t" + element.toString();
            }
            LibVulpes.logger.warn("Cannot add recipe!");
            LibVulpes.logger.warn(message);
        }
    }

    public void addRecipe(Class clazz, Object out, int timeRequired, int power, Object ... inputs) {
        this.addRecipe(clazz, new Object[]{out}, timeRequired, power, inputs);
    }

    public void addRecipe(Class clazz, List<Object> out, int timeRequired, int power, List<Object> inputs) {
        Object[] outputs = new Object[out.size()];
        outputs = out.toArray(outputs);
        Object[] inputs2 = new Object[inputs.size()];
        inputs2 = inputs.toArray(inputs2);
        this.addRecipe(clazz, outputs, timeRequired, power, inputs2);
    }

    public List<IRecipe> getRecipes(Class clazz) {
        return this.recipeList.get(clazz);
    }

    public static class Recipe
    implements IRecipe {
        private List<List<ItemStack>> input;
        private Map<Integer, String> inputOreDict;
        private LinkedList<FluidStack> fluidInput;
        private LinkedList<ItemStack> output;
        private LinkedList<FluidStack> fluidOutput;
        private int completionTime;
        private int power;

        public Recipe() {
        }

        public Recipe(List<ItemStack> output, List<List<ItemStack>> input, int completionTime, int powerReq, Map<Integer, String> oreDict) {
            this.output = new LinkedList();
            this.output.addAll(output);
            this.input = new LinkedList<List<ItemStack>>();
            this.input.addAll(input);
            this.completionTime = completionTime;
            this.power = powerReq;
            this.fluidInput = new LinkedList();
            this.fluidOutput = new LinkedList();
            this.inputOreDict = oreDict;
        }

        public Recipe(List<ItemStack> output, List<List<ItemStack>> input, List<FluidStack> fluidOutput, List<FluidStack> fluidInput, int completionTime, int powerReq, Map<Integer, String> oreDict) {
            this(output, input, completionTime, powerReq, oreDict);
            this.fluidInput.addAll(fluidInput);
            this.fluidOutput.addAll(fluidOutput);
        }

        public int getCompletionTime() {
            return this.completionTime;
        }

        public int getPowerReq() {
            return this.power;
        }

        @Override
        public List<List<ItemStack>> getIngredients() {
            return this.input;
        }

        @Override
        public String getOreDictString(int slot) {
            return this.inputOreDict == null ? null : this.inputOreDict.get(slot);
        }

        @Override
        public List<FluidStack> getFluidIngredients() {
            return this.fluidInput;
        }

        @Override
        public int getTime() {
            return this.completionTime;
        }

        @Override
        public int getPower() {
            return this.power;
        }

        @Override
        public List<ItemStack> getOutput() {
            ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
            for (ItemStack i : this.output) {
                stack.add(i.func_77946_l());
            }
            return stack;
        }

        @Override
        public List<FluidStack> getFluidOutputs() {
            ArrayList<FluidStack> stack = new ArrayList<FluidStack>();
            for (FluidStack i : this.fluidOutput) {
                stack.add(i.copy());
            }
            return stack;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Recipe) {
                int i;
                Recipe otherRecipe = (Recipe)obj;
                if (this.input.size() != otherRecipe.input.size() || this.fluidInput.size() != otherRecipe.fluidInput.size()) {
                    return false;
                }
                for (i = 0; i < this.input.size(); ++i) {
                    if (this.input.get(i).size() != otherRecipe.input.get(i).size()) {
                        return false;
                    }
                    for (int j = 0; j < this.input.get(i).size(); ++j) {
                        if (ItemStack.func_77989_b((ItemStack)this.input.get(i).get(j), (ItemStack)otherRecipe.input.get(i).get(j))) continue;
                        return false;
                    }
                }
                for (i = 0; i < this.fluidInput.size(); ++i) {
                    if (this.fluidInput.get(i).getFluid() == otherRecipe.fluidInput.get(i).getFluid()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

