/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.sound;

import com.google.common.collect.Maps;
import java.util.Map;
import mcjty.efab.config.GeneralConfiguration;
import mcjty.efab.sound.EFabSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public final class SoundController {
    private static SoundEvent machine;
    private static SoundEvent sparks;
    private static SoundEvent steam;
    private static SoundEvent beeps1;
    private static SoundEvent beeps2;
    private static final Map<Pair<Integer, BlockPos>, EFabSound> sounds;

    public static void init(IForgeRegistry<SoundEvent> registry) {
        machine = SoundController.registerSound(registry, new ResourceLocation("efab", "machine"));
        sparks = SoundController.registerSound(registry, new ResourceLocation("efab", "sparks"));
        steam = SoundController.registerSound(registry, new ResourceLocation("efab", "steam"));
        beeps1 = SoundController.registerSound(registry, new ResourceLocation("efab", "beeps1"));
        beeps2 = SoundController.registerSound(registry, new ResourceLocation("efab", "beeps2"));
    }

    private static SoundEvent registerSound(IForgeRegistry<SoundEvent> registry, ResourceLocation rl) {
        SoundEvent ret = (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
        registry.register((IForgeRegistryEntry)ret);
        return ret;
    }

    public static void stopSound(World worldObj, BlockPos pos) {
        Pair<Integer, BlockPos> g = SoundController.fromPosition(worldObj, pos);
        if (sounds.containsKey(g)) {
            MovingSound movingSound = sounds.get(g);
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)movingSound);
            sounds.remove(g);
        }
    }

    private static void playSound(World worldObj, BlockPos pos, SoundEvent soundType, float baseVolume, int ticks) {
        EFabSound sound = new EFabSound(soundType, worldObj, pos, baseVolume, ticks);
        SoundController.stopSound(worldObj, pos);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        Pair g = Pair.of((Object)worldObj.field_73011_w.getDimension(), (Object)pos);
        sounds.put((Pair<Integer, BlockPos>)g, sound);
    }

    public static void playMachineSound(World worldObj, BlockPos pos) {
        SoundController.playSound(worldObj, pos, machine, GeneralConfiguration.baseMachineVolume, GeneralConfiguration.soundMachineTicks);
    }

    public static void playSparksSound(World worldObj, BlockPos pos) {
        SoundController.playSound(worldObj, pos, sparks, GeneralConfiguration.baseSparksVolume, GeneralConfiguration.soundSparksTicks);
    }

    public static void playSteamSound(World worldObj, BlockPos pos) {
        SoundController.playSound(worldObj, pos, steam, GeneralConfiguration.baseSteamVolume, GeneralConfiguration.soundSteamTicks);
    }

    public static void playBeeps1Sound(World worldObj, BlockPos pos) {
        SoundController.playSound(worldObj, pos, beeps1, GeneralConfiguration.baseBeepsVolume, GeneralConfiguration.soundBeepsTicks);
    }

    public static void playBeeps2Sound(World worldObj, BlockPos pos) {
        SoundController.playSound(worldObj, pos, beeps2, GeneralConfiguration.baseBeepsVolume, GeneralConfiguration.soundBeepsTicks);
    }

    public static boolean isMachinePlaying(World worldObj, BlockPos pos) {
        return SoundController.isSoundTypePlayingAt(machine, worldObj, pos);
    }

    public static boolean isSparksPlaying(World worldObj, BlockPos pos) {
        return SoundController.isSoundTypePlayingAt(sparks, worldObj, pos);
    }

    public static boolean isSteamPlaying(World worldObj, BlockPos pos) {
        return SoundController.isSoundTypePlayingAt(steam, worldObj, pos);
    }

    public static boolean isBeepsPlaying(World worldObj, BlockPos pos) {
        return SoundController.isSoundTypePlayingAt(beeps1, worldObj, pos) || SoundController.isSoundTypePlayingAt(beeps2, worldObj, pos);
    }

    private static boolean isSoundTypePlayingAt(SoundEvent event, World world, BlockPos pos) {
        EFabSound s = SoundController.getSoundAt(world, pos);
        if (s == null) {
            return false;
        }
        if (s.func_147667_k()) {
            return false;
        }
        return s.isSoundType(event);
    }

    private static EFabSound getSoundAt(World world, BlockPos pos) {
        return sounds.get(SoundController.fromPosition(world, pos));
    }

    private static Pair<Integer, BlockPos> fromPosition(World world, BlockPos pos) {
        return Pair.of((Object)world.field_73011_w.getDimension(), (Object)pos);
    }

    static {
        sounds = Maps.newHashMap();
    }
}

