/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTools {
    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        double zLevel = 100.0;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), zLevel).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawBox(int x, int y, int width, int height, float r, float g, float b, float a) {
        double zLevel = 100.0;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + height), zLevel).func_181666_a(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), zLevel).func_181666_a(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + 0), zLevel).func_181666_a(r, g, b, a).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + 0), (double)(y + 0), zLevel).func_181666_a(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderQuadBright(double scale, int brightness) {
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        buffer.func_181662_b(-scale, -scale, 0.0).func_187315_a(0.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(-scale, scale, 0.0).func_187315_a(0.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(scale, scale, 0.0).func_187315_a(1.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(scale, -scale, 0.0).func_187315_a(1.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderBillboardQuadBright(double scale, int brightness, float dx, float dy) {
        int b1 = brightness >> 16 & 0xFFFF;
        int b2 = brightness & 0xFFFF;
        GlStateManager.func_179094_E();
        RenderTools.rotateToPlayer();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
        buffer.func_181662_b(-scale + (double)dx, -scale + (double)dy, 0.0).func_187315_a(0.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(-scale + (double)dx, scale + (double)dy, 0.0).func_187315_a(0.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(scale + (double)dx, scale + (double)dy, 0.0).func_187315_a(1.0, 1.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        buffer.func_181662_b(scale + (double)dx, -scale + (double)dy, 0.0).func_187315_a(1.0, 0.0).func_187314_a(b1, b2).func_181669_b(255, 255, 255, 128).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void rotateToPlayer() {
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    public static boolean renderFluidStack(Minecraft mc, FluidStack fluidStack, int x, int y) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return false;
        }
        TextureMap textureMapBlocks = mc.func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite fluidStillSprite = null;
        if (fluidStill != null) {
            fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
        }
        if (fluidStillSprite == null) {
            fluidStillSprite = textureMapBlocks.func_174944_f();
        }
        int fluidColor = fluid.getColor(fluidStack);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderTools.setGLColorFromInt(fluidColor);
        GlStateManager.func_179084_k();
        RenderTools.drawTexture(x, y, fluidStillSprite, 100.0);
        return true;
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private static void drawTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, double zLevel) {
        double uMin = textureSprite.func_94209_e();
        double uMax = textureSprite.func_94212_f();
        double vMin = textureSprite.func_94206_g();
        double vMax = textureSprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(xCoord, yCoord + 16.0, zLevel).func_187315_a(uMin, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0, yCoord + 16.0, zLevel).func_187315_a(uMax, vMax).func_181675_d();
        vertexBuffer.func_181662_b(xCoord + 16.0, yCoord, zLevel).func_187315_a(uMax, vMin).func_181675_d();
        vertexBuffer.func_181662_b(xCoord, yCoord, zLevel).func_187315_a(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }
}

