/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.efab.EFab;
import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.compat.botania.BotaniaSupportSetup;
import mcjty.efab.recipes.EFabShapedRecipe;
import mcjty.efab.recipes.EFabShapelessRecipe;
import mcjty.efab.recipes.IEFabRecipe;
import mcjty.efab.recipes.RecipeManager;
import mcjty.efab.recipes.RecipeTier;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class StandardRecipes {
    public static void init() {
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.gearBoxBlock), new Object[]{"iri", "rbr", "iri", Character.valueOf('i'), "ingotIron", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), ModBlocks.baseBlock}));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.boilerBlock), new Object[]{"ici", "ibi", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), ModBlocks.baseBlock, Character.valueOf('c'), Blocks.field_150383_bp}).tier(RecipeTier.GEARBOX).time(20));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.tankBlock), "iii", "i i", "iii", Character.valueOf('i'), "ingotIron").tier(RecipeTier.GEARBOX).time(10));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.tank2Block), "iii", "i i", "iii", Character.valueOf('i'), "blockIron").tier(RecipeTier.GEARBOX).time(50));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.steamEngineBlock), new Object[]{"ici", "ibi", "ici", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), ModBlocks.baseBlock, Character.valueOf('c'), Blocks.field_150331_J}).tier(RecipeTier.GEARBOX).time(20));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.pipeBlock), "ii ", "ii ", "   ", Character.valueOf('i'), "ingotIron").tier(RecipeTier.GEARBOX).time(10));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.storageBlock), "iii", " c ", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), Blocks.field_150486_ae).tier(RecipeTier.GEARBOX).time(40));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.crafterBlock), "iii", " c ", "iii", Character.valueOf('i'), "ingotIron", Character.valueOf('c'), Blocks.field_150462_ai).tier(RecipeTier.GEARBOX).time(40));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.rfControlBlock), new Object[]{"rrr", "rbr", "rrr", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), ModBlocks.baseBlock}).tier(RecipeTier.STEAM).time(100));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.powerOptimizerBlock), new Object[]{"rrr", "rbr", "rrr", Character.valueOf('r'), Blocks.field_150451_bX, Character.valueOf('b'), ModBlocks.baseBlock}).tier(RecipeTier.RF).tier(RecipeTier.COMPUTING).rfPerTick(50).time(1000));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.processorBlock), new Object[]{"rqr", "rbr", "rqr", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), ModBlocks.baseBlock, Character.valueOf('q'), Items.field_151128_bU}).tier(RecipeTier.RF).rfPerTick(10).time(100));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.monitorBlock), new Object[]{"dqd", "qbq", "dqd", Character.valueOf('d'), "dyeBlack", Character.valueOf('b'), ModBlocks.baseBlock, Character.valueOf('q'), Items.field_151128_bU}).tier(RecipeTier.RF).tier(RecipeTier.COMPUTING).rfPerTick(10).time(100));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.autoCraftingMonitorBlock), new Object[]{"rqr", "qbq", "dqd", Character.valueOf('d'), "dyeBlack", Character.valueOf('b'), ModBlocks.baseBlock, Character.valueOf('q'), Items.field_151128_bU, Character.valueOf('r'), Items.field_151137_ax}).tier(RecipeTier.RF).tier(RecipeTier.COMPUTING).rfPerTick(10).time(100));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.rfStorageBlock), new Object[]{"rRr", "RbR", "rRr", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), ModBlocks.baseBlock, Character.valueOf('R'), Blocks.field_150451_bX}).tier(RecipeTier.STEAM).tier(RecipeTier.LIQUID).fluid(new FluidStack(FluidRegistry.LAVA, 1000)).time(100));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)ModBlocks.advancedRfStorageBlock), new Object[]{"rRr", "RbR", "rRr", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), ModBlocks.rfStorageBlock, Character.valueOf('R'), Blocks.field_150451_bX}).tier(RecipeTier.RF).rfPerTick(200).time(500));
        if (EFab.botania) {
            RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack(BotaniaSupportSetup.getManaReceptacle()), new Object[]{"drr", "rbd", "rdr", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('b'), ModBlocks.baseBlock, Character.valueOf('d'), Items.field_151045_i}).tier(RecipeTier.RF).rfPerTick(40).time(100));
            RecipeManager.registerRecipe(new EFabShapelessRecipe(new ItemStack(Blocks.field_150380_bt), "   ", " e ", "   ", Character.valueOf('e'), Items.field_151110_aK).tier(RecipeTier.MANA).manaPerTick(20).time(200));
        }
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack(Blocks.field_150460_al), "ccc", "c c", "ccc", Character.valueOf('c'), Blocks.field_150347_e));
        RecipeManager.registerRecipe(new EFabShapelessRecipe(new ItemStack(Items.field_151114_aO), "r", Character.valueOf('r'), Items.field_151137_ax).tier(RecipeTier.RF).rfPerTick(10).time(100));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack((Block)Blocks.field_150331_J), "ppp", "crc", "cic", Character.valueOf('p'), "plankWood", Character.valueOf('c'), "cobblestone", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('i'), "ingotIron").time(20).tier(RecipeTier.GEARBOX));
        RecipeManager.registerRecipe(new EFabShapedRecipe(new ItemStack(Blocks.field_150343_Z), "ccc", "ccc", "ccc", Character.valueOf('c'), "cobblestone").time(60).tier(RecipeTier.STEAM).tier(RecipeTier.LIQUID).tier(RecipeTier.RF).rfPerTick(10).fluid(new FluidStack(FluidRegistry.WATER, 1000)).fluid(new FluidStack(FluidRegistry.LAVA, 1000)));
        RecipeManager.registerRecipe(new EFabShapelessRecipe(new ItemStack(Items.field_151131_as), "b", Character.valueOf('b'), Items.field_151133_ar).time(40).tier(RecipeTier.LIQUID).fluid(new FluidStack(FluidRegistry.WATER, 1000)));
        RecipeManager.registerRecipe(new EFabShapelessRecipe(new ItemStack(Items.field_151129_at), "b", Character.valueOf('b'), Items.field_151133_ar).time(40).tier(RecipeTier.LIQUID).fluid(new FluidStack(FluidRegistry.LAVA, 1000)));
    }

    public static void readRecipesConfig(File file) {
        FileInputStream inputstream;
        if (!file.exists()) {
            Logging.log((String)"efab_recipes.cfg does not exist, usting defaults");
            return;
        }
        try {
            inputstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Logging.log((String)("Note: No file " + file.getName()));
            return;
        }
        StandardRecipes.readRecipesFromStream(inputstream, file.getName());
    }

    private static FluidStack jsonToFluidStack(JsonObject obj) {
        String fluidName = obj.get("fluid").getAsString();
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        int amount = obj.get("amount").getAsInt();
        NBTTagCompound nbt = null;
        if (obj.has("nbt")) {
            try {
                nbt = JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString());
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        return new FluidStack(fluid, amount, nbt);
    }

    private static JsonObject fluidStackToJson(FluidStack fluid) {
        JsonObject object = new JsonObject();
        object.add("fluid", (JsonElement)new JsonPrimitive(fluid.getFluid().getName()));
        object.add("amount", (JsonElement)new JsonPrimitive((Number)fluid.amount));
        if (fluid.tag != null) {
            String string = fluid.tag.toString();
            object.add("nbt", (JsonElement)new JsonPrimitive(string));
        }
        return object;
    }

    private static ItemStack jsonToItemStack(JsonObject obj) {
        String itemName = obj.get("item").getAsString();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = 1;
        if (obj.has("amount")) {
            amount = obj.get("amount").getAsInt();
        }
        int meta = 0;
        if (obj.has("meta")) {
            meta = obj.get("meta").getAsInt();
        }
        ItemStack stack = new ItemStack(item, amount, meta);
        if (obj.has("nbt")) {
            try {
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)obj.get("nbt").getAsString());
                stack.func_77982_d(nbt);
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        return stack;
    }

    private static JsonObject itemStackToJson(ItemStack item) {
        JsonObject object = new JsonObject();
        object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
        if (item.func_190916_E() != 1) {
            object.add("amount", (JsonElement)new JsonPrimitive((Number)item.func_190916_E()));
        }
        if (item.func_77952_i() != 0) {
            object.add("meta", (JsonElement)new JsonPrimitive((Number)item.func_77952_i()));
        }
        if (item.func_77942_o()) {
            String string = item.func_77978_p().toString();
            object.add("nbt", (JsonElement)new JsonPrimitive(string));
        }
        return object;
    }

    public static void writeDefaults(File file) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            Logging.logError((String)("Error writing " + file.getName()));
            return;
        }
        JsonArray array = new JsonArray();
        RecipeManager.getRecipes().stream().forEach(recipe -> array.add((JsonElement)StandardRecipes.recipeToJson(recipe)));
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        writer.print(gson.toJson((JsonElement)array));
        writer.close();
    }

    private static IEFabRecipe jsonToRecipe(JsonObject obj) {
        String type = obj.get("type").getAsString();
        boolean shaped = "shaped".equals(type.toLowerCase());
        ArrayList<Object> input = new ArrayList<Object>();
        JsonArray inputArray = obj.get("input").getAsJsonArray();
        for (int i = 0; i < inputArray.size(); ++i) {
            input.add(inputArray.get(i).getAsString());
        }
        JsonObject inputMapObject = obj.get("inputmap").getAsJsonObject();
        for (Map.Entry entry : inputMapObject.entrySet()) {
            input.add(Character.valueOf(((String)entry.getKey()).charAt(0)));
            JsonElement value = (JsonElement)entry.getValue();
            if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                input.add(value.getAsString());
                continue;
            }
            if (!value.isJsonObject()) continue;
            input.add(StandardRecipes.jsonToItemStack(value.getAsJsonObject()));
        }
        ItemStack output = StandardRecipes.jsonToItemStack(obj.get("output").getAsJsonObject());
        ShapedOreRecipe recipe = shaped ? new EFabShapedRecipe(output, input.toArray(new Object[input.size()])) : new EFabShapelessRecipe(output, input.toArray(new Object[input.size()]));
        if (obj.has("copynbt")) {
            String copyFrom = obj.get("copynbt").getAsString();
            recipe.copyNBTFrom(copyFrom);
        }
        recipe.time(obj.get("time").getAsInt());
        if (obj.has("tiers")) {
            JsonArray tiersArray = obj.get("tiers").getAsJsonArray();
            for (JsonElement element : tiersArray) {
                RecipeTier tier = RecipeTier.valueOf(element.getAsString());
                recipe.tier(tier);
            }
        }
        if (obj.has("rfpertick")) {
            recipe.rfPerTick(obj.get("rfpertick").getAsInt());
        }
        if (obj.has("manapertick")) {
            recipe.manaPerTick(obj.get("manapertick").getAsInt());
        }
        if (obj.has("fluids")) {
            JsonArray fluidArray = obj.get("fluids").getAsJsonArray();
            for (JsonElement element : fluidArray) {
                FluidStack stack = StandardRecipes.jsonToFluidStack(element.getAsJsonObject());
                recipe.fluid(stack);
            }
        }
        return recipe;
    }

    private static JsonObject recipeToJson(IEFabRecipe recipe) {
        List<FluidStack> fluids;
        JsonObject obj = new JsonObject();
        obj.add("type", (JsonElement)new JsonPrimitive(recipe instanceof EFabShapedRecipe ? "shaped" : "shapeless"));
        obj.add("output", (JsonElement)StandardRecipes.itemStackToJson(recipe.cast().func_77571_b()));
        List<String> inputs = recipe.getInputs();
        JsonArray inputArray = new JsonArray();
        for (String input : inputs) {
            inputArray.add((JsonElement)new JsonPrimitive(input));
        }
        obj.add("input", (JsonElement)inputArray);
        Map<String, Object> inputMap = recipe.getInputMap();
        JsonObject inputMapObject = new JsonObject();
        for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
            Object value = entry.getValue();
            Object element = value instanceof String ? new JsonPrimitive((String)value) : (value instanceof ItemStack ? StandardRecipes.itemStackToJson((ItemStack)value) : (value instanceof Item ? StandardRecipes.itemStackToJson(new ItemStack((Item)value)) : (value instanceof Block ? StandardRecipes.itemStackToJson(new ItemStack((Block)value)) : new JsonPrimitive("ERROR"))));
            inputMapObject.add(entry.getKey(), (JsonElement)element);
        }
        obj.add("inputmap", (JsonElement)inputMapObject);
        if (recipe.getCopyNBTFrom() != null) {
            obj.add("copynbt", (JsonElement)new JsonPrimitive(recipe.getCopyNBTFrom()));
        }
        obj.add("time", (JsonElement)new JsonPrimitive((Number)recipe.getCraftTime()));
        Set<RecipeTier> tiers = recipe.getRequiredTiers();
        if (!tiers.isEmpty()) {
            JsonArray tierArray = new JsonArray();
            for (RecipeTier tier : tiers) {
                tierArray.add((JsonElement)new JsonPrimitive(tier.name()));
            }
            obj.add("tiers", (JsonElement)tierArray);
        }
        if (recipe.getRequiredRfPerTick() > 0) {
            obj.add("rfpertick", (JsonElement)new JsonPrimitive((Number)recipe.getRequiredRfPerTick()));
        }
        if (recipe.getRequiredManaPerTick() > 0) {
            obj.add("manapertick", (JsonElement)new JsonPrimitive((Number)recipe.getRequiredManaPerTick()));
        }
        if (!(fluids = recipe.getRequiredFluids()).isEmpty()) {
            JsonArray fluidArray = new JsonArray();
            for (FluidStack fluid : fluids) {
                fluidArray.add((JsonElement)StandardRecipes.fluidStackToJson(fluid));
            }
            obj.add("fluids", (JsonElement)fluidArray);
        }
        return obj;
    }

    private static void readRecipesFromStream(InputStream inputstream, String name) {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Logging.logError((String)("Error reading file: " + name));
            return;
        }
        RecipeManager.clear();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (JsonElement entry : element.getAsJsonArray()) {
            StandardRecipes.readRecipe(entry);
        }
    }

    private static void readRecipe(JsonElement element) {
        IEFabRecipe recipe = StandardRecipes.jsonToRecipe(element.getAsJsonObject());
        RecipeManager.registerRecipe(recipe);
    }
}

