/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.efab.recipes.IEFabRecipe;
import mcjty.efab.recipes.RecipeTier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class EFabShapedRecipe
extends ShapedOreRecipe
implements IEFabRecipe {
    @Nonnull
    private final Set<RecipeTier> requiredTiers = EnumSet.noneOf(RecipeTier.class);
    @Nonnull
    private final List<FluidStack> requiredFluids = new ArrayList<FluidStack>();
    private int requiredRfPerTick = 0;
    private int requiredManaPerTick = 0;
    private int craftTime = 0;
    private String copyNBT;
    private List<String> inputs = new ArrayList<String>();
    private Map<String, Object> inputMap = new HashMap<String, Object>();

    public EFabShapedRecipe(ItemStack output, Object ... recipe) {
        super(new ResourceLocation("efab", "shaped"), output, recipe);
        int idx = 0;
        while (idx < recipe.length) {
            Object o = recipe[idx];
            ++idx;
            if (o instanceof String) {
                this.inputs.add((String)o);
                continue;
            }
            if (!(o instanceof Character)) continue;
            Object item = recipe[idx];
            ++idx;
            this.inputMap.put(String.valueOf(o), item);
        }
    }

    @Override
    public List<List<ItemStack>> getInputLists() {
        ArrayList<List<ItemStack>> inputLists = new ArrayList<List<ItemStack>>();
        for (Object o : this.input) {
            if (o instanceof Ingredient) {
                ItemStack[] stacks = ((Ingredient)o).func_193365_a();
                inputLists.add(Arrays.asList(stacks));
                continue;
            }
            if (o instanceof ItemStack) {
                inputLists.add(Collections.singletonList((ItemStack)o));
                continue;
            }
            if (o instanceof List) {
                inputLists.add((List)o);
                continue;
            }
            inputLists.add(Collections.emptyList());
        }
        return inputLists;
    }

    @Override
    public void copyNBTFrom(String character) {
        this.copyNBT = character;
    }

    @Override
    public String getCopyNBTFrom() {
        return this.copyNBT;
    }

    @Override
    public List<String> getInputs() {
        return this.inputs;
    }

    @Override
    public Map<String, Object> getInputMap() {
        return this.inputMap;
    }

    @Override
    public IEFabRecipe tier(RecipeTier tier) {
        this.requiredTiers.add(tier);
        return this;
    }

    @Override
    public IEFabRecipe fluid(FluidStack stack) {
        this.requiredFluids.add(stack);
        return this;
    }

    @Override
    public IEFabRecipe rfPerTick(int rf) {
        this.requiredRfPerTick = rf;
        return this;
    }

    @Override
    public IEFabRecipe manaPerTick(int mana) {
        this.requiredManaPerTick = mana;
        return this;
    }

    @Override
    public IEFabRecipe time(int t) {
        this.craftTime = t;
        return this;
    }

    @Override
    @Nonnull
    public List<FluidStack> getRequiredFluids() {
        return this.requiredFluids;
    }

    @Override
    public int getRequiredRfPerTick() {
        return this.requiredRfPerTick;
    }

    @Override
    public int getRequiredManaPerTick() {
        return this.requiredManaPerTick;
    }

    @Override
    public int getCraftTime() {
        return this.craftTime;
    }

    @Override
    @Nonnull
    public Set<RecipeTier> getRequiredTiers() {
        return this.requiredTiers;
    }

    @Override
    @Nonnull
    public IRecipe cast() {
        return this;
    }
}

