/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.proxy;

import java.io.File;
import mcjty.efab.EFab;
import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.compat.botania.BotaniaSupportSetup;
import mcjty.efab.config.GeneralConfiguration;
import mcjty.efab.items.ModItems;
import mcjty.efab.network.EFabMessages;
import mcjty.efab.proxy.GuiProxy;
import mcjty.efab.recipes.RecipeManager;
import mcjty.efab.recipes.StandardRecipes;
import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.proxy.AbstractCommonProxy;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy
extends AbstractCommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        RecipeManager.init();
        this.mainConfig = new Configuration(new File(this.modConfigDir.getPath(), "efab.cfg"));
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"efab", (String)"efab");
        EFabMessages.registerNetworkMessages(network);
        ModItems.init();
        ModBlocks.init();
        if (EFab.botania) {
            BotaniaSupportSetup.preInit();
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        McJtyRegister.registerBlocks((ModBase)EFab.instance, (IForgeRegistry)event.getRegistry());
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        McJtyRegister.registerItems((ModBase)EFab.instance, (IForgeRegistry)event.getRegistry());
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "General settings");
            GeneralConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)EFab.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        this.mainConfig = null;
        StandardRecipes.init();
        if (EFab.botania) {
            BotaniaSupportSetup.postInit();
        }
        File file = new File(this.modConfigDir.getPath(), "efab_recipes.json");
        StandardRecipes.readRecipesConfig(file);
    }
}

