/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.efab.EFab;
import mcjty.efab.blocks.crafter.CrafterTE;
import mcjty.efab.blocks.grid.GridTE;
import mcjty.lib.network.NetworkTools;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketReturnGridStatus
implements IMessage {
    private BlockPos pos;
    private int ticks;
    private int total;
    private List<String> errors;
    private List<String> usage;
    private List<ItemStack> outputs;

    public void fromBytes(ByteBuf buf) {
        int i;
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.ticks = buf.readInt();
        this.total = buf.readInt();
        int size = buf.readInt();
        this.errors = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.errors.add(NetworkTools.readStringUTF8((ByteBuf)buf));
        }
        size = buf.readInt();
        this.usage = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.usage.add(NetworkTools.readStringUTF8((ByteBuf)buf));
        }
        size = buf.readInt();
        this.outputs = new ArrayList<ItemStack>(size);
        for (i = 0; i < size; ++i) {
            this.outputs.add(NetworkTools.readItemStack((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.ticks);
        buf.writeInt(this.total);
        buf.writeInt(this.errors.size());
        for (String error : this.errors) {
            NetworkTools.writeStringUTF8((ByteBuf)buf, (String)error);
        }
        buf.writeInt(this.usage.size());
        for (String use : this.usage) {
            NetworkTools.writeStringUTF8((ByteBuf)buf, (String)use);
        }
        buf.writeInt(this.outputs.size());
        for (ItemStack output : this.outputs) {
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)output);
        }
    }

    public PacketReturnGridStatus() {
    }

    public PacketReturnGridStatus(BlockPos pos, GridTE gridTE) {
        this.pos = pos;
        this.ticks = gridTE.getTicksRemaining();
        this.total = gridTE.getTotalTicks();
        this.errors = gridTE.getErrorState();
        this.usage = gridTE.getUsage();
        this.outputs = gridTE.getOutputs();
    }

    public PacketReturnGridStatus(BlockPos pos, CrafterTE crafterTE) {
        this.pos = pos;
        this.ticks = 0;
        this.total = 0;
        this.errors = Collections.singletonList(crafterTE.getLastError());
        this.usage = Collections.emptyList();
        this.outputs = crafterTE.getOutputs();
    }

    public static class Handler
    implements IMessageHandler<PacketReturnGridStatus, IMessage> {
        public IMessage onMessage(PacketReturnGridStatus message, MessageContext ctx) {
            EFab.proxy.addScheduledTaskClient(() -> {
                TileEntity te = EFab.proxy.getClientWorld().func_175625_s(message.pos);
                if (te instanceof GridTE) {
                    ((GridTE)te).syncFromServer(message.ticks, message.total, message.errors, message.outputs, message.usage);
                } else if (te instanceof CrafterTE) {
                    ((CrafterTE)te).syncFromServer(message.errors, message.outputs);
                }
            });
            return null;
        }
    }
}

