/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.compat.jei.grid;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.efab.blocks.grid.GridGui;
import mcjty.efab.compat.jei.grid.Tooltip;
import mcjty.efab.recipes.IEFabRecipe;
import mcjty.efab.recipes.RecipeTier;
import mcjty.efab.render.RenderTools;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

class GridCraftingRecipeWrapper
implements IRecipeWrapper,
IShapedCraftingRecipeWrapper {
    private final IEFabRecipe recipe;
    private final List<List<ItemStack>> inputs;
    private final List<List<FluidStack>> fluidInputs;
    private final ItemStack output;
    private final List<Tooltip> tooltips = new ArrayList<Tooltip>();
    private static final ResourceLocation ICONS = new ResourceLocation("efab", "textures/gui/icons.png");
    private static DecimalFormat format = new DecimalFormat("#.##");

    public GridCraftingRecipeWrapper(IEFabRecipe recipe) {
        this.recipe = recipe;
        this.inputs = recipe.getInputLists();
        this.fluidInputs = Collections.singletonList(recipe.getRequiredFluids());
        this.output = recipe.cast().func_77571_b();
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setOutput(ItemStack.class, (Object)this.output);
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setInputLists(FluidStack.class, this.fluidInputs);
    }

    private static String formatPower(long l) {
        if (l < 10000L) {
            return Long.toString(l);
        }
        if (l < 1000000L) {
            Double d = (double)l / 1000.0;
            return format.format(d) + "K";
        }
        if (l < 1000000000L) {
            Double d = (double)l / 1000000.0;
            return format.format(d) + "M";
        }
        Double d = (double)l / 1.0E9;
        return format.format(d) + "G";
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.tooltips.clear();
        Set<RecipeTier> tiers = this.recipe.getRequiredTiers();
        int y = 60;
        minecraft.field_71466_p.func_78276_b("Time", 0, y, Color.black.getRGB());
        minecraft.field_71466_p.func_78276_b("" + GridGui.getTime(this.recipe.getCraftTime(), false), 28, y, Color.blue.getRGB());
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int x = 0;
        y += 12;
        int perTick = this.recipe.getRequiredRfPerTick();
        if (perTick > 0) {
            minecraft.field_71466_p.func_78276_b("RF", 0, y, Color.black.getRGB());
            long total = (long)perTick * (long)this.recipe.getCraftTime();
            minecraft.field_71466_p.func_78276_b("" + GridCraftingRecipeWrapper.formatPower(total) + "RF @ " + GridCraftingRecipeWrapper.formatPower(perTick) + "RF/t", 28, y, Color.blue.getRGB());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            x = 0;
            y += 12;
        }
        if (this.recipe.getRequiredManaPerTick() > 0) {
            minecraft.field_71466_p.func_78276_b("Mana", 0, y, Color.black.getRGB());
            minecraft.field_71466_p.func_78276_b("" + this.recipe.getRequiredManaPerTick() + " mana/tick", 28, y, Color.blue.getRGB());
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            x = 0;
            y += 12;
        }
        int cury = y;
        for (RecipeTier tier : tiers) {
            minecraft.func_110434_K().func_110577_a(ICONS);
            RenderTools.drawTexturedModalRect(x, y, tier.getIconX(), tier.getIconY(), 16, 16);
            this.tooltips.add(new Tooltip(x, y, 16, 16).add(tier.name()));
            if ((x += 20) + 18 < 80) continue;
            x = 0;
            y += 20;
        }
        y = cury;
        if (!this.recipe.getRequiredFluids().isEmpty()) {
            x = 80;
            for (FluidStack stack : this.recipe.getRequiredFluids()) {
                String name = stack.getLocalizedName();
                GlStateManager.func_179090_x();
                RenderTools.drawBox(x - 1, y - 1, 18, 18, 0.0f, 0.0f, 0.0f, 1.0f);
                GlStateManager.func_179098_w();
                RenderTools.renderFluidStack(minecraft, stack, x, y);
                if (this.recipe.getRequiredFluids().size() <= 1) {
                    minecraft.field_71466_p.func_78276_b(name, x + 20, y + 5, Color.blue.getRGB());
                }
                this.tooltips.add(new Tooltip(x, y, 16, 16).add(TextFormatting.BLUE + "Fluid: " + TextFormatting.WHITE + name).add(TextFormatting.BLUE + "Amount: " + TextFormatting.WHITE + stack.amount + " mb"));
                x += 20;
            }
        }
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        for (Tooltip tooltip : this.tooltips) {
            if (!tooltip.in(mouseX, mouseY)) continue;
            return tooltip.getTooltips();
        }
        return Collections.emptyList();
    }
}

