/*
 * Decompiled with CFR 0.152.
 */
package mcjty.efab.compat.jei;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.efab.blocks.ModBlocks;
import mcjty.efab.blocks.crafter.CrafterContainer;
import mcjty.efab.blocks.crafter.CrafterTE;
import mcjty.efab.blocks.grid.GridContainer;
import mcjty.efab.compat.jei.JEIRecipeAdapter;
import mcjty.efab.compat.jei.grid.GridRecipeCategory;
import mcjty.efab.compat.jei.grid.GridRecipeWrapperFactory;
import mcjty.efab.config.GeneralConfiguration;
import mcjty.efab.network.EFabMessages;
import mcjty.efab.network.PacketSendRecipe;
import mcjty.efab.recipes.IEFabRecipe;
import mcjty.efab.recipes.RecipeManager;
import mcjty.efab.tools.ItemStackList;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@JEIPlugin
public class EFabJeiPlugin
implements IModPlugin {
    public void register(@Nonnull IModRegistry registry) {
        registry.handleRecipes(IEFabRecipe.class, (IRecipeWrapperFactory)new GridRecipeWrapperFactory(), "EFabGrid");
        List efabRecipes = RecipeManager.getRecipes().stream().map(JEIRecipeAdapter::new).collect(Collectors.toList());
        registry.addRecipes(efabRecipes, "EFabGrid");
        IRecipeTransferRegistry transferRegistry = registry.getRecipeTransferRegistry();
        if (GeneralConfiguration.vanillaCraftingAllowed) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.gridBlock), new String[]{"EFabGrid", "minecraft.crafting"});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crafterBlock), new String[]{"EFabGrid", "minecraft.crafting"});
            transferRegistry.addRecipeTransferHandler(GridContainer.class, "minecraft.crafting", 0, 9, 22, 36);
        } else {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.gridBlock), new String[]{"EFabGrid"});
            registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crafterBlock), new String[]{"EFabGrid"});
        }
        transferRegistry.addRecipeTransferHandler(GridContainer.class, "EFabGrid", 0, 9, 22, 36);
        IRecipeTransferHandler<CrafterContainer> handler = new IRecipeTransferHandler<CrafterContainer>(){

            public Class<CrafterContainer> getContainerClass() {
                return CrafterContainer.class;
            }

            @Nullable
            public IRecipeTransferError transferRecipe(CrafterContainer container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
                Map guiIngredients = recipeLayout.getItemStacks().getGuiIngredients();
                IInventory inventory = container.getInventory("container");
                BlockPos pos = ((CrafterTE)inventory).func_174877_v();
                if (doTransfer) {
                    EFabJeiPlugin.sendIngredients(guiIngredients, pos);
                }
                return null;
            }
        };
        transferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)handler, "EFabGrid");
        transferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)handler, "minecraft.crafting");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new GridRecipeCategory(guiHelper)});
    }

    public static void sendIngredients(Map<Integer, ? extends IGuiIngredient<ItemStack>> guiIngredients, BlockPos pos) {
        ItemStackList items = ItemStackList.create(10);
        for (Map.Entry<Integer, ? extends IGuiIngredient<ItemStack>> entry : guiIngredients.entrySet()) {
            int recipeSlot = entry.getKey();
            List allIngredients = entry.getValue().getAllIngredients();
            if (allIngredients.isEmpty()) continue;
            items.set(recipeSlot, allIngredients.get(0));
        }
        EFabMessages.INSTANCE.sendToServer((IMessage)new PacketSendRecipe(items, pos));
    }
}

